/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary;
import software.amazon.awssdk.services.forecast.model.WhatIfForecastsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWhatIfForecastsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListWhatIfForecastsResponse> {
    private static final SdkField<List<WhatIfForecastSummary>> WHAT_IF_FORECASTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WhatIfForecasts").getter(ListWhatIfForecastsResponse.getter(ListWhatIfForecastsResponse::whatIfForecasts)).setter(ListWhatIfForecastsResponse.setter(Builder::whatIfForecasts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecasts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WhatIfForecastSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWhatIfForecastsResponse.getter(ListWhatIfForecastsResponse::nextToken)).setter(ListWhatIfForecastsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_FORECASTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<WhatIfForecastSummary> whatIfForecasts;
    private final String nextToken;

    private ListWhatIfForecastsResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfForecasts = builder.whatIfForecasts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWhatIfForecasts() {
        return this.whatIfForecasts != null && !(this.whatIfForecasts instanceof SdkAutoConstructList);
    }

    public final List<WhatIfForecastSummary> whatIfForecasts() {
        return this.whatIfForecasts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWhatIfForecasts() ? this.whatIfForecasts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWhatIfForecastsResponse)) {
            return false;
        }
        ListWhatIfForecastsResponse other = (ListWhatIfForecastsResponse)((Object)obj);
        return this.hasWhatIfForecasts() == other.hasWhatIfForecasts() && Objects.equals(this.whatIfForecasts(), other.whatIfForecasts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWhatIfForecastsResponse").add("WhatIfForecasts", this.hasWhatIfForecasts() ? this.whatIfForecasts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WhatIfForecasts": {
                return Optional.ofNullable(clazz.cast(this.whatIfForecasts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWhatIfForecastsResponse, T> g) {
        return obj -> g.apply((ListWhatIfForecastsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<WhatIfForecastSummary> whatIfForecasts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWhatIfForecastsResponse model) {
            super(model);
            this.whatIfForecasts(model.whatIfForecasts);
            this.nextToken(model.nextToken);
        }

        public final List<WhatIfForecastSummary.Builder> getWhatIfForecasts() {
            List<WhatIfForecastSummary.Builder> result = WhatIfForecastsCopier.copyToBuilder(this.whatIfForecasts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWhatIfForecasts(Collection<WhatIfForecastSummary.BuilderImpl> whatIfForecasts) {
            this.whatIfForecasts = WhatIfForecastsCopier.copyFromBuilder(whatIfForecasts);
        }

        @Override
        public final Builder whatIfForecasts(Collection<WhatIfForecastSummary> whatIfForecasts) {
            this.whatIfForecasts = WhatIfForecastsCopier.copy(whatIfForecasts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecasts(WhatIfForecastSummary ... whatIfForecasts) {
            this.whatIfForecasts(Arrays.asList(whatIfForecasts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecasts(Consumer<WhatIfForecastSummary.Builder> ... whatIfForecasts) {
            this.whatIfForecasts(Stream.of(whatIfForecasts).map(c -> (WhatIfForecastSummary)((WhatIfForecastSummary.Builder)WhatIfForecastSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWhatIfForecastsResponse build() {
            return new ListWhatIfForecastsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWhatIfForecastsResponse> {
        public Builder whatIfForecasts(Collection<WhatIfForecastSummary> var1);

        public Builder whatIfForecasts(WhatIfForecastSummary ... var1);

        public Builder whatIfForecasts(Consumer<WhatIfForecastSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

