/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest;
import software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse;
import software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluation;

public class ListMonitorEvaluationsPublisher
implements SdkPublisher<ListMonitorEvaluationsResponse> {
    private final ForecastAsyncClient client;
    private final ListMonitorEvaluationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMonitorEvaluationsPublisher(ForecastAsyncClient client, ListMonitorEvaluationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMonitorEvaluationsPublisher(ForecastAsyncClient client, ListMonitorEvaluationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMonitorEvaluationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMonitorEvaluationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PredictorMonitorEvaluation> predictorMonitorEvaluations() {
        Function<ListMonitorEvaluationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.predictorMonitorEvaluations() != null) {
                return response.predictorMonitorEvaluations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMonitorEvaluationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMonitorEvaluationsResponseFetcher
    implements AsyncPageFetcher<ListMonitorEvaluationsResponse> {
        private ListMonitorEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitorEvaluationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMonitorEvaluationsResponse> nextPage(ListMonitorEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return ListMonitorEvaluationsPublisher.this.client.listMonitorEvaluations(ListMonitorEvaluationsPublisher.this.firstRequest);
            }
            return ListMonitorEvaluationsPublisher.this.client.listMonitorEvaluations((ListMonitorEvaluationsRequest)((Object)ListMonitorEvaluationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

