/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsResponse;
import software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary;

public class ListWhatIfForecastExportsIterable
implements SdkIterable<ListWhatIfForecastExportsResponse> {
    private final ForecastClient client;
    private final ListWhatIfForecastExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWhatIfForecastExportsIterable(ForecastClient client, ListWhatIfForecastExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWhatIfForecastExportsResponseFetcher();
    }

    public Iterator<ListWhatIfForecastExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WhatIfForecastExportSummary> whatIfForecastExports() {
        Function<ListWhatIfForecastExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.whatIfForecastExports() != null) {
                return response.whatIfForecastExports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWhatIfForecastExportsResponseFetcher
    implements SyncPageFetcher<ListWhatIfForecastExportsResponse> {
        private ListWhatIfForecastExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatIfForecastExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWhatIfForecastExportsResponse nextPage(ListWhatIfForecastExportsResponse previousPage) {
            if (previousPage == null) {
                return ListWhatIfForecastExportsIterable.this.client.listWhatIfForecastExports(ListWhatIfForecastExportsIterable.this.firstRequest);
            }
            return ListWhatIfForecastExportsIterable.this.client.listWhatIfForecastExports((ListWhatIfForecastExportsRequest)((Object)ListWhatIfForecastExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

