/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.DataSource;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.Tag;
import software.amazon.awssdk.services.forecast.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetImportJobRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateDatasetImportJobRequest> {
    private static final SdkField<String> DATASET_IMPORT_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetImportJobName").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::datasetImportJobName)).setter(CreateDatasetImportJobRequest.setter(Builder::datasetImportJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobName").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::datasetArn)).setter(CreateDatasetImportJobRequest.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::dataSource)).setter(CreateDatasetImportJobRequest.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampFormat").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::timestampFormat)).setter(CreateDatasetImportJobRequest.setter(Builder::timestampFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZone").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::timeZone)).setter(CreateDatasetImportJobRequest.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final SdkField<Boolean> USE_GEOLOCATION_FOR_TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseGeolocationForTimeZone").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::useGeolocationForTimeZone)).setter(CreateDatasetImportJobRequest.setter(Builder::useGeolocationForTimeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseGeolocationForTimeZone").build()}).build();
    private static final SdkField<String> GEOLOCATION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeolocationFormat").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::geolocationFormat)).setter(CreateDatasetImportJobRequest.setter(Builder::geolocationFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeolocationFormat").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::tags)).setter(CreateDatasetImportJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_NAME_FIELD, DATASET_ARN_FIELD, DATA_SOURCE_FIELD, TIMESTAMP_FORMAT_FIELD, TIME_ZONE_FIELD, USE_GEOLOCATION_FOR_TIME_ZONE_FIELD, GEOLOCATION_FORMAT_FIELD, TAGS_FIELD));
    private final String datasetImportJobName;
    private final String datasetArn;
    private final DataSource dataSource;
    private final String timestampFormat;
    private final String timeZone;
    private final Boolean useGeolocationForTimeZone;
    private final String geolocationFormat;
    private final List<Tag> tags;

    private CreateDatasetImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobName = builder.datasetImportJobName;
        this.datasetArn = builder.datasetArn;
        this.dataSource = builder.dataSource;
        this.timestampFormat = builder.timestampFormat;
        this.timeZone = builder.timeZone;
        this.useGeolocationForTimeZone = builder.useGeolocationForTimeZone;
        this.geolocationFormat = builder.geolocationFormat;
        this.tags = builder.tags;
    }

    public final String datasetImportJobName() {
        return this.datasetImportJobName;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String timestampFormat() {
        return this.timestampFormat;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final Boolean useGeolocationForTimeZone() {
        return this.useGeolocationForTimeZone;
    }

    public final String geolocationFormat() {
        return this.geolocationFormat;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetImportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.useGeolocationForTimeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.geolocationFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetImportJobRequest)) {
            return false;
        }
        CreateDatasetImportJobRequest other = (CreateDatasetImportJobRequest)((Object)obj);
        return Objects.equals(this.datasetImportJobName(), other.datasetImportJobName()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.timestampFormat(), other.timestampFormat()) && Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.useGeolocationForTimeZone(), other.useGeolocationForTimeZone()) && Objects.equals(this.geolocationFormat(), other.geolocationFormat()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetImportJobRequest").add("DatasetImportJobName", (Object)this.datasetImportJobName()).add("DatasetArn", (Object)this.datasetArn()).add("DataSource", (Object)this.dataSource()).add("TimestampFormat", (Object)this.timestampFormat()).add("TimeZone", (Object)this.timeZone()).add("UseGeolocationForTimeZone", (Object)this.useGeolocationForTimeZone()).add("GeolocationFormat", (Object)this.geolocationFormat()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetImportJobName": {
                return Optional.ofNullable(clazz.cast(this.datasetImportJobName()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "TimestampFormat": {
                return Optional.ofNullable(clazz.cast(this.timestampFormat()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "UseGeolocationForTimeZone": {
                return Optional.ofNullable(clazz.cast(this.useGeolocationForTimeZone()));
            }
            case "GeolocationFormat": {
                return Optional.ofNullable(clazz.cast(this.geolocationFormat()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetImportJobRequest, T> g) {
        return obj -> g.apply((CreateDatasetImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String datasetImportJobName;
        private String datasetArn;
        private DataSource dataSource;
        private String timestampFormat;
        private String timeZone;
        private Boolean useGeolocationForTimeZone;
        private String geolocationFormat;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetImportJobRequest model) {
            super(model);
            this.datasetImportJobName(model.datasetImportJobName);
            this.datasetArn(model.datasetArn);
            this.dataSource(model.dataSource);
            this.timestampFormat(model.timestampFormat);
            this.timeZone(model.timeZone);
            this.useGeolocationForTimeZone(model.useGeolocationForTimeZone);
            this.geolocationFormat(model.geolocationFormat);
            this.tags(model.tags);
        }

        public final String getDatasetImportJobName() {
            return this.datasetImportJobName;
        }

        public final void setDatasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
        }

        @Override
        public final Builder datasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getTimestampFormat() {
            return this.timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final Boolean getUseGeolocationForTimeZone() {
            return this.useGeolocationForTimeZone;
        }

        public final void setUseGeolocationForTimeZone(Boolean useGeolocationForTimeZone) {
            this.useGeolocationForTimeZone = useGeolocationForTimeZone;
        }

        @Override
        public final Builder useGeolocationForTimeZone(Boolean useGeolocationForTimeZone) {
            this.useGeolocationForTimeZone = useGeolocationForTimeZone;
            return this;
        }

        public final String getGeolocationFormat() {
            return this.geolocationFormat;
        }

        public final void setGeolocationFormat(String geolocationFormat) {
            this.geolocationFormat = geolocationFormat;
        }

        @Override
        public final Builder geolocationFormat(String geolocationFormat) {
            this.geolocationFormat = geolocationFormat;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetImportJobRequest build() {
            return new CreateDatasetImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetImportJobRequest> {
        public Builder datasetImportJobName(String var1);

        public Builder datasetArn(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder timestampFormat(String var1);

        public Builder timeZone(String var1);

        public Builder useGeolocationForTimeZone(Boolean var1);

        public Builder geolocationFormat(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

