/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ViolationReason {
    WEB_ACL_MISSING_RULE_GROUP("WEB_ACL_MISSING_RULE_GROUP"),
    RESOURCE_MISSING_WEB_ACL("RESOURCE_MISSING_WEB_ACL"),
    RESOURCE_INCORRECT_WEB_ACL("RESOURCE_INCORRECT_WEB_ACL"),
    RESOURCE_MISSING_SHIELD_PROTECTION("RESOURCE_MISSING_SHIELD_PROTECTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ViolationReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ViolationReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ViolationReason.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ViolationReason> knownValues() {
        return Stream.of(ViolationReason.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

