/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationResult> {
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EvaluationResult.getter(EvaluationResult::complianceStatusAsString)).setter(EvaluationResult.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceStatus").build()}).build();
    private static final SdkField<Long> VIOLATOR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(EvaluationResult.getter(EvaluationResult::violatorCount)).setter(EvaluationResult.setter(Builder::violatorCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatorCount").build()}).build();
    private static final SdkField<Boolean> EVALUATION_LIMIT_EXCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(EvaluationResult.getter(EvaluationResult::evaluationLimitExceeded)).setter(EvaluationResult.setter(Builder::evaluationLimitExceeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationLimitExceeded").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_STATUS_FIELD, VIOLATOR_COUNT_FIELD, EVALUATION_LIMIT_EXCEEDED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String complianceStatus;
    private final Long violatorCount;
    private final Boolean evaluationLimitExceeded;

    private EvaluationResult(BuilderImpl builder) {
        this.complianceStatus = builder.complianceStatus;
        this.violatorCount = builder.violatorCount;
        this.evaluationLimitExceeded = builder.evaluationLimitExceeded;
    }

    public PolicyComplianceStatusType complianceStatus() {
        return PolicyComplianceStatusType.fromValue(this.complianceStatus);
    }

    public String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public Long violatorCount() {
        return this.violatorCount;
    }

    public Boolean evaluationLimitExceeded() {
        return this.evaluationLimitExceeded;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.violatorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationLimitExceeded());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        return Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.violatorCount(), other.violatorCount()) && Objects.equals(this.evaluationLimitExceeded(), other.evaluationLimitExceeded());
    }

    public String toString() {
        return ToString.builder((String)"EvaluationResult").add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("ViolatorCount", (Object)this.violatorCount()).add("EvaluationLimitExceeded", (Object)this.evaluationLimitExceeded()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "ViolatorCount": {
                return Optional.ofNullable(clazz.cast(this.violatorCount()));
            }
            case "EvaluationLimitExceeded": {
                return Optional.ofNullable(clazz.cast(this.evaluationLimitExceeded()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResult, T> g) {
        return obj -> g.apply((EvaluationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceStatus;
        private Long violatorCount;
        private Boolean evaluationLimitExceeded;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            this.complianceStatus(model.complianceStatus);
            this.violatorCount(model.violatorCount);
            this.evaluationLimitExceeded(model.evaluationLimitExceeded);
        }

        public final String getComplianceStatusAsString() {
            return this.complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(PolicyComplianceStatusType complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        public final Long getViolatorCount() {
            return this.violatorCount;
        }

        @Override
        public final Builder violatorCount(Long violatorCount) {
            this.violatorCount = violatorCount;
            return this;
        }

        public final void setViolatorCount(Long violatorCount) {
            this.violatorCount = violatorCount;
        }

        public final Boolean getEvaluationLimitExceeded() {
            return this.evaluationLimitExceeded;
        }

        @Override
        public final Builder evaluationLimitExceeded(Boolean evaluationLimitExceeded) {
            this.evaluationLimitExceeded = evaluationLimitExceeded;
            return this;
        }

        public final void setEvaluationLimitExceeded(Boolean evaluationLimitExceeded) {
            this.evaluationLimitExceeded = evaluationLimitExceeded;
        }

        public EvaluationResult build() {
            return new EvaluationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationResult> {
        public Builder complianceStatus(String var1);

        public Builder complianceStatus(PolicyComplianceStatusType var1);

        public Builder violatorCount(Long var1);

        public Builder evaluationLimitExceeded(Boolean var1);
    }
}

