/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for the handling of the stateful rule groups in a Network Firewall firewall policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatefulEngineOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<StatefulEngineOptions.Builder, StatefulEngineOptions> {
    private static final SdkField<String> RULE_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleOrder").getter(getter(StatefulEngineOptions::ruleOrderAsString)).setter(setter(Builder::ruleOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()).build();

    private static final SdkField<String> STREAM_EXCEPTION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamExceptionPolicy").getter(getter(StatefulEngineOptions::streamExceptionPolicyAsString))
            .setter(setter(Builder::streamExceptionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamExceptionPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ORDER_FIELD,
            STREAM_EXCEPTION_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleOrder;

    private final String streamExceptionPolicy;

    private StatefulEngineOptions(BuilderImpl builder) {
        this.ruleOrder = builder.ruleOrder;
        this.streamExceptionPolicy = builder.streamExceptionPolicy;
    }

    /**
     * <p>
     * Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are provided to the
     * rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     * >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Default: <code>DEFAULT_ACTION_ORDER</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleOrder} will
     * return {@link RuleOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleOrderAsString}.
     * </p>
     * 
     * @return Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are provided
     *         to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     *         >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.</p>
     *         <p>
     *         Default: <code>DEFAULT_ACTION_ORDER</code>
     * @see RuleOrder
     */
    public final RuleOrder ruleOrder() {
        return RuleOrder.fromValue(ruleOrder);
    }

    /**
     * <p>
     * Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are provided to the
     * rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     * >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Default: <code>DEFAULT_ACTION_ORDER</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleOrder} will
     * return {@link RuleOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleOrderAsString}.
     * </p>
     * 
     * @return Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are provided
     *         to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
     *         >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.</p>
     *         <p>
     *         Default: <code>DEFAULT_ACTION_ORDER</code>
     * @see RuleOrder
     */
    public final String ruleOrderAsString() {
        return ruleOrder;
    }

    /**
     * <p>
     * Indicates how Network Firewall should handle traffic when a network connection breaks midstream.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic before the
     * break. This impacts the behavior of rules that depend on context. For example, with a stateful rule that drops
     * HTTP traffic, Network Firewall won't match subsequent traffic because the it won't have the context from session
     * initialization, which defines the application layer protocol as HTTP. However, a TCP-layer rule using a
     * <code>flow:stateless</code> rule would still match, and so would the <code>aws:drop_strict</code> default action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this option,
     * Network Firewall also sends a TCP reject packet back to the client so the client can immediately establish a new
     * session. With the new session, Network Firewall will have context and will apply rules appropriately.
     * </p>
     * <p>
     * For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer idle timeouts,
     * this is the recommended setting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FMS_IGNORE</code> - Firewall Manager doesn't monitor or modify the Network Firewall stream exception policy
     * settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html">Stream
     * exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Default: <code>FMS_IGNORE</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamExceptionPolicy} will return {@link StreamExceptionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamExceptionPolicyAsString}.
     * </p>
     * 
     * @return Indicates how Network Firewall should handle traffic when a network connection breaks midstream.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic before
     *         the break. This impacts the behavior of rules that depend on context. For example, with a stateful rule
     *         that drops HTTP traffic, Network Firewall won't match subsequent traffic because the it won't have the
     *         context from session initialization, which defines the application layer protocol as HTTP. However, a
     *         TCP-layer rule using a <code>flow:stateless</code> rule would still match, and so would the
     *         <code>aws:drop_strict</code> default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this
     *         option, Network Firewall also sends a TCP reject packet back to the client so the client can immediately
     *         establish a new session. With the new session, Network Firewall will have context and will apply rules
     *         appropriately.
     *         </p>
     *         <p>
     *         For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer idle
     *         timeouts, this is the recommended setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FMS_IGNORE</code> - Firewall Manager doesn't monitor or modify the Network Firewall stream
     *         exception policy settings.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html"
     *         >Stream exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.
     *         </p>
     *         <p>
     *         Default: <code>FMS_IGNORE</code>
     * @see StreamExceptionPolicy
     */
    public final StreamExceptionPolicy streamExceptionPolicy() {
        return StreamExceptionPolicy.fromValue(streamExceptionPolicy);
    }

    /**
     * <p>
     * Indicates how Network Firewall should handle traffic when a network connection breaks midstream.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic before the
     * break. This impacts the behavior of rules that depend on context. For example, with a stateful rule that drops
     * HTTP traffic, Network Firewall won't match subsequent traffic because the it won't have the context from session
     * initialization, which defines the application layer protocol as HTTP. However, a TCP-layer rule using a
     * <code>flow:stateless</code> rule would still match, and so would the <code>aws:drop_strict</code> default action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this option,
     * Network Firewall also sends a TCP reject packet back to the client so the client can immediately establish a new
     * session. With the new session, Network Firewall will have context and will apply rules appropriately.
     * </p>
     * <p>
     * For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer idle timeouts,
     * this is the recommended setting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FMS_IGNORE</code> - Firewall Manager doesn't monitor or modify the Network Firewall stream exception policy
     * settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html">Stream
     * exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Default: <code>FMS_IGNORE</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamExceptionPolicy} will return {@link StreamExceptionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamExceptionPolicyAsString}.
     * </p>
     * 
     * @return Indicates how Network Firewall should handle traffic when a network connection breaks midstream.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic before
     *         the break. This impacts the behavior of rules that depend on context. For example, with a stateful rule
     *         that drops HTTP traffic, Network Firewall won't match subsequent traffic because the it won't have the
     *         context from session initialization, which defines the application layer protocol as HTTP. However, a
     *         TCP-layer rule using a <code>flow:stateless</code> rule would still match, and so would the
     *         <code>aws:drop_strict</code> default action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this
     *         option, Network Firewall also sends a TCP reject packet back to the client so the client can immediately
     *         establish a new session. With the new session, Network Firewall will have context and will apply rules
     *         appropriately.
     *         </p>
     *         <p>
     *         For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer idle
     *         timeouts, this is the recommended setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FMS_IGNORE</code> - Firewall Manager doesn't monitor or modify the Network Firewall stream
     *         exception policy settings.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html"
     *         >Stream exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.
     *         </p>
     *         <p>
     *         Default: <code>FMS_IGNORE</code>
     * @see StreamExceptionPolicy
     */
    public final String streamExceptionPolicyAsString() {
        return streamExceptionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamExceptionPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatefulEngineOptions)) {
            return false;
        }
        StatefulEngineOptions other = (StatefulEngineOptions) obj;
        return Objects.equals(ruleOrderAsString(), other.ruleOrderAsString())
                && Objects.equals(streamExceptionPolicyAsString(), other.streamExceptionPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatefulEngineOptions").add("RuleOrder", ruleOrderAsString())
                .add("StreamExceptionPolicy", streamExceptionPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleOrder":
            return Optional.ofNullable(clazz.cast(ruleOrderAsString()));
        case "StreamExceptionPolicy":
            return Optional.ofNullable(clazz.cast(streamExceptionPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleOrder", RULE_ORDER_FIELD);
        map.put("StreamExceptionPolicy", STREAM_EXCEPTION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatefulEngineOptions, T> g) {
        return obj -> g.apply((StatefulEngineOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatefulEngineOptions> {
        /**
         * <p>
         * Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are provided to
         * the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         * >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * <p>
         * Default: <code>DEFAULT_ACTION_ORDER</code>
         * </p>
         * 
         * @param ruleOrder
         *        Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are
         *        provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on
         *        certain settings. For more information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         *        >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.</p>
         *        <p>
         *        Default: <code>DEFAULT_ACTION_ORDER</code>
         * @see RuleOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOrder
         */
        Builder ruleOrder(String ruleOrder);

        /**
         * <p>
         * Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are provided to
         * the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         * >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * <p>
         * Default: <code>DEFAULT_ACTION_ORDER</code>
         * </p>
         * 
         * @param ruleOrder
         *        Indicates how to manage the order of stateful rule evaluation for the policy. Stateful rules are
         *        provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on
         *        certain settings. For more information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html"
         *        >Evaluation order for stateful rules</a> in the <i>Network Firewall Developer Guide</i>.</p>
         *        <p>
         *        Default: <code>DEFAULT_ACTION_ORDER</code>
         * @see RuleOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOrder
         */
        Builder ruleOrder(RuleOrder ruleOrder);

        /**
         * <p>
         * Indicates how Network Firewall should handle traffic when a network connection breaks midstream.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic before the
         * break. This impacts the behavior of rules that depend on context. For example, with a stateful rule that
         * drops HTTP traffic, Network Firewall won't match subsequent traffic because the it won't have the context
         * from session initialization, which defines the application layer protocol as HTTP. However, a TCP-layer rule
         * using a <code>flow:stateless</code> rule would still match, and so would the <code>aws:drop_strict</code>
         * default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this option,
         * Network Firewall also sends a TCP reject packet back to the client so the client can immediately establish a
         * new session. With the new session, Network Firewall will have context and will apply rules appropriately.
         * </p>
         * <p>
         * For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer idle
         * timeouts, this is the recommended setting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FMS_IGNORE</code> - Firewall Manager doesn't monitor or modify the Network Firewall stream exception
         * policy settings.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html">Stream
         * exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * <p>
         * Default: <code>FMS_IGNORE</code>
         * </p>
         * 
         * @param streamExceptionPolicy
         *        Indicates how Network Firewall should handle traffic when a network connection breaks midstream.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic
         *        before the break. This impacts the behavior of rules that depend on context. For example, with a
         *        stateful rule that drops HTTP traffic, Network Firewall won't match subsequent traffic because the it
         *        won't have the context from session initialization, which defines the application layer protocol as
         *        HTTP. However, a TCP-layer rule using a <code>flow:stateless</code> rule would still match, and so
         *        would the <code>aws:drop_strict</code> default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this
         *        option, Network Firewall also sends a TCP reject packet back to the client so the client can
         *        immediately establish a new session. With the new session, Network Firewall will have context and will
         *        apply rules appropriately.
         *        </p>
         *        <p>
         *        For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer
         *        idle timeouts, this is the recommended setting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FMS_IGNORE</code> - Firewall Manager doesn't monitor or modify the Network Firewall stream
         *        exception policy settings.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html"
         *        >Stream exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.
         *        </p>
         *        <p>
         *        Default: <code>FMS_IGNORE</code>
         * @see StreamExceptionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamExceptionPolicy
         */
        Builder streamExceptionPolicy(String streamExceptionPolicy);

        /**
         * <p>
         * Indicates how Network Firewall should handle traffic when a network connection breaks midstream.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic before the
         * break. This impacts the behavior of rules that depend on context. For example, with a stateful rule that
         * drops HTTP traffic, Network Firewall won't match subsequent traffic because the it won't have the context
         * from session initialization, which defines the application layer protocol as HTTP. However, a TCP-layer rule
         * using a <code>flow:stateless</code> rule would still match, and so would the <code>aws:drop_strict</code>
         * default action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this option,
         * Network Firewall also sends a TCP reject packet back to the client so the client can immediately establish a
         * new session. With the new session, Network Firewall will have context and will apply rules appropriately.
         * </p>
         * <p>
         * For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer idle
         * timeouts, this is the recommended setting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FMS_IGNORE</code> - Firewall Manager doesn't monitor or modify the Network Firewall stream exception
         * policy settings.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html">Stream
         * exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * <p>
         * Default: <code>FMS_IGNORE</code>
         * </p>
         * 
         * @param streamExceptionPolicy
         *        Indicates how Network Firewall should handle traffic when a network connection breaks midstream.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DROP</code> - Fail closed and drop all subsequent traffic going to the firewall.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONTINUE</code> - Continue to apply rules to subsequent traffic without context from traffic
         *        before the break. This impacts the behavior of rules that depend on context. For example, with a
         *        stateful rule that drops HTTP traffic, Network Firewall won't match subsequent traffic because the it
         *        won't have the context from session initialization, which defines the application layer protocol as
         *        HTTP. However, a TCP-layer rule using a <code>flow:stateless</code> rule would still match, and so
         *        would the <code>aws:drop_strict</code> default action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECT</code> - Fail closed and drop all subsequent traffic going to the firewall. With this
         *        option, Network Firewall also sends a TCP reject packet back to the client so the client can
         *        immediately establish a new session. With the new session, Network Firewall will have context and will
         *        apply rules appropriately.
         *        </p>
         *        <p>
         *        For applications that are reliant on long-lived TCP connections that trigger Gateway Load Balancer
         *        idle timeouts, this is the recommended setting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FMS_IGNORE</code> - Firewall Manager doesn't monitor or modify the Network Firewall stream
         *        exception policy settings.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/stream-exception-policy.html"
         *        >Stream exception policy in your firewall policy</a> in the <i>Network Firewall Developer Guide</i>.
         *        </p>
         *        <p>
         *        Default: <code>FMS_IGNORE</code>
         * @see StreamExceptionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamExceptionPolicy
         */
        Builder streamExceptionPolicy(StreamExceptionPolicy streamExceptionPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String ruleOrder;

        private String streamExceptionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(StatefulEngineOptions model) {
            ruleOrder(model.ruleOrder);
            streamExceptionPolicy(model.streamExceptionPolicy);
        }

        public final String getRuleOrder() {
            return ruleOrder;
        }

        public final void setRuleOrder(String ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(String ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        @Override
        public final Builder ruleOrder(RuleOrder ruleOrder) {
            this.ruleOrder(ruleOrder == null ? null : ruleOrder.toString());
            return this;
        }

        public final String getStreamExceptionPolicy() {
            return streamExceptionPolicy;
        }

        public final void setStreamExceptionPolicy(String streamExceptionPolicy) {
            this.streamExceptionPolicy = streamExceptionPolicy;
        }

        @Override
        public final Builder streamExceptionPolicy(String streamExceptionPolicy) {
            this.streamExceptionPolicy = streamExceptionPolicy;
            return this;
        }

        @Override
        public final Builder streamExceptionPolicy(StreamExceptionPolicy streamExceptionPolicy) {
            this.streamExceptionPolicy(streamExceptionPolicy == null ? null : streamExceptionPolicy.toString());
            return this;
        }

        @Override
        public StatefulEngineOptions build() {
            return new StatefulEngineOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
