/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNotificationChannelResponse extends FmsResponse implements
        ToCopyableBuilder<GetNotificationChannelResponse.Builder, GetNotificationChannelResponse> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(GetNotificationChannelResponse::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SNS_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsRoleName").getter(getter(GetNotificationChannelResponse::snsRoleName))
            .setter(setter(Builder::snsRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsRoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD,
            SNS_ROLE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String snsTopicArn;

    private final String snsRoleName;

    private GetNotificationChannelResponse(BuilderImpl builder) {
        super(builder);
        this.snsTopicArn = builder.snsTopicArn;
        this.snsRoleName = builder.snsRoleName;
    }

    /**
     * <p>
     * The SNS topic that records Firewall Manager activity.
     * </p>
     * 
     * @return The SNS topic that records Firewall Manager activity.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The IAM role that is used by Firewall Manager to record activity to SNS.
     * </p>
     * 
     * @return The IAM role that is used by Firewall Manager to record activity to SNS.
     */
    public final String snsRoleName() {
        return snsRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsRoleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNotificationChannelResponse)) {
            return false;
        }
        GetNotificationChannelResponse other = (GetNotificationChannelResponse) obj;
        return Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(snsRoleName(), other.snsRoleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNotificationChannelResponse").add("SnsTopicArn", snsTopicArn())
                .add("SnsRoleName", snsRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SnsRoleName":
            return Optional.ofNullable(clazz.cast(snsRoleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("SnsRoleName", SNS_ROLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNotificationChannelResponse, T> g) {
        return obj -> g.apply((GetNotificationChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetNotificationChannelResponse> {
        /**
         * <p>
         * The SNS topic that records Firewall Manager activity.
         * </p>
         * 
         * @param snsTopicArn
         *        The SNS topic that records Firewall Manager activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The IAM role that is used by Firewall Manager to record activity to SNS.
         * </p>
         * 
         * @param snsRoleName
         *        The IAM role that is used by Firewall Manager to record activity to SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsRoleName(String snsRoleName);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private String snsTopicArn;

        private String snsRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNotificationChannelResponse model) {
            super(model);
            snsTopicArn(model.snsTopicArn);
            snsRoleName(model.snsRoleName);
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsRoleName() {
            return snsRoleName;
        }

        public final void setSnsRoleName(String snsRoleName) {
            this.snsRoleName = snsRoleName;
        }

        @Override
        public final Builder snsRoleName(String snsRoleName) {
            this.snsRoleName = snsRoleName;
            return this;
        }

        @Override
        public GetNotificationChannelResponse build() {
            return new GetNotificationChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
