/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the expected route in the route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpectedRoute implements SdkPojo, Serializable, ToCopyableBuilder<ExpectedRoute.Builder, ExpectedRoute> {
    private static final SdkField<String> IP_V4_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpV4Cidr").getter(getter(ExpectedRoute::ipV4Cidr)).setter(setter(Builder::ipV4Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV4Cidr").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId").getter(getter(ExpectedRoute::prefixListId)).setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").build()).build();

    private static final SdkField<String> IP_V6_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpV6Cidr").getter(getter(ExpectedRoute::ipV6Cidr)).setter(setter(Builder::ipV6Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV6Cidr").build()).build();

    private static final SdkField<List<String>> CONTRIBUTING_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContributingSubnets")
            .getter(getter(ExpectedRoute::contributingSubnets))
            .setter(setter(Builder::contributingSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributingSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedTargets")
            .getter(getter(ExpectedRoute::allowedTargets))
            .setter(setter(Builder::allowedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId").getter(getter(ExpectedRoute::routeTableId)).setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_V4_CIDR_FIELD,
            PREFIX_LIST_ID_FIELD, IP_V6_CIDR_FIELD, CONTRIBUTING_SUBNETS_FIELD, ALLOWED_TARGETS_FIELD, ROUTE_TABLE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipV4Cidr;

    private final String prefixListId;

    private final String ipV6Cidr;

    private final List<String> contributingSubnets;

    private final List<String> allowedTargets;

    private final String routeTableId;

    private ExpectedRoute(BuilderImpl builder) {
        this.ipV4Cidr = builder.ipV4Cidr;
        this.prefixListId = builder.prefixListId;
        this.ipV6Cidr = builder.ipV6Cidr;
        this.contributingSubnets = builder.contributingSubnets;
        this.allowedTargets = builder.allowedTargets;
        this.routeTableId = builder.routeTableId;
    }

    /**
     * <p>
     * Information about the IPv4 CIDR block.
     * </p>
     * 
     * @return Information about the IPv4 CIDR block.
     */
    public final String ipV4Cidr() {
        return ipV4Cidr;
    }

    /**
     * <p>
     * Information about the ID of the prefix list for the route.
     * </p>
     * 
     * @return Information about the ID of the prefix list for the route.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR block.
     * </p>
     * 
     * @return Information about the IPv6 CIDR block.
     */
    public final String ipV6Cidr() {
        return ipV6Cidr;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContributingSubnets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContributingSubnets() {
        return contributingSubnets != null && !(contributingSubnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the contributing subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContributingSubnets} method.
     * </p>
     * 
     * @return Information about the contributing subnets.
     */
    public final List<String> contributingSubnets() {
        return contributingSubnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedTargets() {
        return allowedTargets != null && !(allowedTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the allowed targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedTargets} method.
     * </p>
     * 
     * @return Information about the allowed targets.
     */
    public final List<String> allowedTargets() {
        return allowedTargets;
    }

    /**
     * <p>
     * Information about the route table ID.
     * </p>
     * 
     * @return Information about the route table ID.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipV4Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(ipV6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(hasContributingSubnets() ? contributingSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedTargets() ? allowedTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpectedRoute)) {
            return false;
        }
        ExpectedRoute other = (ExpectedRoute) obj;
        return Objects.equals(ipV4Cidr(), other.ipV4Cidr()) && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(ipV6Cidr(), other.ipV6Cidr()) && hasContributingSubnets() == other.hasContributingSubnets()
                && Objects.equals(contributingSubnets(), other.contributingSubnets())
                && hasAllowedTargets() == other.hasAllowedTargets() && Objects.equals(allowedTargets(), other.allowedTargets())
                && Objects.equals(routeTableId(), other.routeTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpectedRoute").add("IpV4Cidr", ipV4Cidr()).add("PrefixListId", prefixListId())
                .add("IpV6Cidr", ipV6Cidr()).add("ContributingSubnets", hasContributingSubnets() ? contributingSubnets() : null)
                .add("AllowedTargets", hasAllowedTargets() ? allowedTargets() : null).add("RouteTableId", routeTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpV4Cidr":
            return Optional.ofNullable(clazz.cast(ipV4Cidr()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "IpV6Cidr":
            return Optional.ofNullable(clazz.cast(ipV6Cidr()));
        case "ContributingSubnets":
            return Optional.ofNullable(clazz.cast(contributingSubnets()));
        case "AllowedTargets":
            return Optional.ofNullable(clazz.cast(allowedTargets()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpV4Cidr", IP_V4_CIDR_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("IpV6Cidr", IP_V6_CIDR_FIELD);
        map.put("ContributingSubnets", CONTRIBUTING_SUBNETS_FIELD);
        map.put("AllowedTargets", ALLOWED_TARGETS_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpectedRoute, T> g) {
        return obj -> g.apply((ExpectedRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpectedRoute> {
        /**
         * <p>
         * Information about the IPv4 CIDR block.
         * </p>
         * 
         * @param ipV4Cidr
         *        Information about the IPv4 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Cidr(String ipV4Cidr);

        /**
         * <p>
         * Information about the ID of the prefix list for the route.
         * </p>
         * 
         * @param prefixListId
         *        Information about the ID of the prefix list for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * Information about the IPv6 CIDR block.
         * </p>
         * 
         * @param ipV6Cidr
         *        Information about the IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Cidr(String ipV6Cidr);

        /**
         * <p>
         * Information about the contributing subnets.
         * </p>
         * 
         * @param contributingSubnets
         *        Information about the contributing subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributingSubnets(Collection<String> contributingSubnets);

        /**
         * <p>
         * Information about the contributing subnets.
         * </p>
         * 
         * @param contributingSubnets
         *        Information about the contributing subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributingSubnets(String... contributingSubnets);

        /**
         * <p>
         * Information about the allowed targets.
         * </p>
         * 
         * @param allowedTargets
         *        Information about the allowed targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedTargets(Collection<String> allowedTargets);

        /**
         * <p>
         * Information about the allowed targets.
         * </p>
         * 
         * @param allowedTargets
         *        Information about the allowed targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedTargets(String... allowedTargets);

        /**
         * <p>
         * Information about the route table ID.
         * </p>
         * 
         * @param routeTableId
         *        Information about the route table ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);
    }

    static final class BuilderImpl implements Builder {
        private String ipV4Cidr;

        private String prefixListId;

        private String ipV6Cidr;

        private List<String> contributingSubnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedTargets = DefaultSdkAutoConstructList.getInstance();

        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpectedRoute model) {
            ipV4Cidr(model.ipV4Cidr);
            prefixListId(model.prefixListId);
            ipV6Cidr(model.ipV6Cidr);
            contributingSubnets(model.contributingSubnets);
            allowedTargets(model.allowedTargets);
            routeTableId(model.routeTableId);
        }

        public final String getIpV4Cidr() {
            return ipV4Cidr;
        }

        public final void setIpV4Cidr(String ipV4Cidr) {
            this.ipV4Cidr = ipV4Cidr;
        }

        @Override
        public final Builder ipV4Cidr(String ipV4Cidr) {
            this.ipV4Cidr = ipV4Cidr;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getIpV6Cidr() {
            return ipV6Cidr;
        }

        public final void setIpV6Cidr(String ipV6Cidr) {
            this.ipV6Cidr = ipV6Cidr;
        }

        @Override
        public final Builder ipV6Cidr(String ipV6Cidr) {
            this.ipV6Cidr = ipV6Cidr;
            return this;
        }

        public final Collection<String> getContributingSubnets() {
            if (contributingSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return contributingSubnets;
        }

        public final void setContributingSubnets(Collection<String> contributingSubnets) {
            this.contributingSubnets = ResourceIdListCopier.copy(contributingSubnets);
        }

        @Override
        public final Builder contributingSubnets(Collection<String> contributingSubnets) {
            this.contributingSubnets = ResourceIdListCopier.copy(contributingSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributingSubnets(String... contributingSubnets) {
            contributingSubnets(Arrays.asList(contributingSubnets));
            return this;
        }

        public final Collection<String> getAllowedTargets() {
            if (allowedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedTargets;
        }

        public final void setAllowedTargets(Collection<String> allowedTargets) {
            this.allowedTargets = LengthBoundedStringListCopier.copy(allowedTargets);
        }

        @Override
        public final Builder allowedTargets(Collection<String> allowedTargets) {
            this.allowedTargets = LengthBoundedStringListCopier.copy(allowedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedTargets(String... allowedTargets) {
            allowedTargets(Arrays.asList(allowedTargets));
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        @Override
        public ExpectedRoute build() {
            return new ExpectedRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
