/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An individual Firewall Manager application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class App implements SdkPojo, Serializable, ToCopyableBuilder<App.Builder, App> {
    private static final SdkField<String> APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppName").getter(getter(App::appName)).setter(setter(Builder::appName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppName").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(App::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Long> PORT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Port")
            .getter(getter(App::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_NAME_FIELD,
            PROTOCOL_FIELD, PORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appName;

    private final String protocol;

    private final Long port;

    private App(BuilderImpl builder) {
        this.appName = builder.appName;
        this.protocol = builder.protocol;
        this.port = builder.port;
    }

    /**
     * <p>
     * The application's name.
     * </p>
     * 
     * @return The application's name.
     */
    public final String appName() {
        return appName;
    }

    /**
     * <p>
     * The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or <code>icmp</code>.
     * For information on possible numbers, see <a
     * href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.
     * </p>
     * 
     * @return The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or
     *         <code>icmp</code>. For information on possible numbers, see <a
     *         href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The application's port number, for example <code>80</code>.
     * </p>
     * 
     * @return The application's port number, for example <code>80</code>.
     */
    public final Long port() {
        return port;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appName());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App) obj;
        return Objects.equals(appName(), other.appName()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(port(), other.port());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("App").add("AppName", appName()).add("Protocol", protocol()).add("Port", port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppName":
            return Optional.ofNullable(clazz.cast(appName()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppName", APP_NAME_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Port", PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<App, T> g) {
        return obj -> g.apply((App) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, App> {
        /**
         * <p>
         * The application's name.
         * </p>
         * 
         * @param appName
         *        The application's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appName(String appName);

        /**
         * <p>
         * The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or
         * <code>icmp</code>. For information on possible numbers, see <a
         * href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.
         * </p>
         * 
         * @param protocol
         *        The IP protocol name or number. The name can be one of <code>tcp</code>, <code>udp</code>, or
         *        <code>icmp</code>. For information on possible numbers, see <a
         *        href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The application's port number, for example <code>80</code>.
         * </p>
         * 
         * @param port
         *        The application's port number, for example <code>80</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Long port);
    }

    static final class BuilderImpl implements Builder {
        private String appName;

        private String protocol;

        private Long port;

        private BuilderImpl() {
        }

        private BuilderImpl(App model) {
            appName(model.appName);
            protocol(model.protocol);
            port(model.port);
        }

        public final String getAppName() {
            return appName;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Long getPort() {
            return port;
        }

        public final void setPort(Long port) {
            this.port = port;
        }

        @Override
        public final Builder port(Long port) {
            this.port = port;
            return this;
        }

        @Override
        public App build() {
            return new App(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
