/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.DestinationType;
import software.amazon.awssdk.services.fms.model.TargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Route
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Route> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationType").getter(Route.getter(Route::destinationTypeAsString)).setter(Route.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(Route.getter(Route::targetTypeAsString)).setter(Route.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(Route.getter(Route::destination)).setter(Route.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(Route.getter(Route::target)).setter(Route.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD, TARGET_TYPE_FIELD, DESTINATION_FIELD, TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Route.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationType;
    private final String targetType;
    private final String destination;
    private final String target;

    private Route(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.targetType = builder.targetType;
        this.destination = builder.destination;
        this.target = builder.target;
    }

    public final DestinationType destinationType() {
        return DestinationType.fromValue(this.destinationType);
    }

    public final String destinationTypeAsString() {
        return this.destinationType;
    }

    public final TargetType targetType() {
        return TargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final String destination() {
        return this.destination;
    }

    public final String target() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route)obj;
        return Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.target(), other.target());
    }

    public final String toString() {
        return ToString.builder((String)"Route").add("DestinationType", (Object)this.destinationTypeAsString()).add("TargetType", (Object)this.targetTypeAsString()).add("Destination", (Object)this.destination()).add("Target", (Object)this.target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DestinationType", DESTINATION_TYPE_FIELD);
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Target", TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route, T> g) {
        return obj -> g.apply((Route)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationType;
        private String targetType;
        private String destination;
        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            this.destinationType(model.destinationType);
            this.targetType(model.targetType);
            this.destination(model.destination);
            this.target(model.target);
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public Route build() {
            return new Route(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Route> {
        public Builder destinationType(String var1);

        public Builder destinationType(DestinationType var1);

        public Builder targetType(String var1);

        public Builder targetType(TargetType var1);

        public Builder destination(String var1);

        public Builder target(String var1);
    }
}

