/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.Route;
import software.amazon.awssdk.services.fms.model.RoutesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFirewallBlackHoleRouteDetectedViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFirewallBlackHoleRouteDetectedViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationTarget").getter(NetworkFirewallBlackHoleRouteDetectedViolation.getter(NetworkFirewallBlackHoleRouteDetectedViolation::violationTarget)).setter(NetworkFirewallBlackHoleRouteDetectedViolation.setter(Builder::violationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(NetworkFirewallBlackHoleRouteDetectedViolation.getter(NetworkFirewallBlackHoleRouteDetectedViolation::routeTableId)).setter(NetworkFirewallBlackHoleRouteDetectedViolation.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(NetworkFirewallBlackHoleRouteDetectedViolation.getter(NetworkFirewallBlackHoleRouteDetectedViolation::vpcId)).setter(NetworkFirewallBlackHoleRouteDetectedViolation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViolatingRoutes").getter(NetworkFirewallBlackHoleRouteDetectedViolation.getter(NetworkFirewallBlackHoleRouteDetectedViolation::violatingRoutes)).setter(NetworkFirewallBlackHoleRouteDetectedViolation.setter(Builder::violatingRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD, ROUTE_TABLE_ID_FIELD, VPC_ID_FIELD, VIOLATING_ROUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkFirewallBlackHoleRouteDetectedViolation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String violationTarget;
    private final String routeTableId;
    private final String vpcId;
    private final List<Route> violatingRoutes;

    private NetworkFirewallBlackHoleRouteDetectedViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.routeTableId = builder.routeTableId;
        this.vpcId = builder.vpcId;
        this.violatingRoutes = builder.violatingRoutes;
    }

    public final String violationTarget() {
        return this.violationTarget;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasViolatingRoutes() {
        return this.violatingRoutes != null && !(this.violatingRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> violatingRoutes() {
        return this.violatingRoutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViolatingRoutes() ? this.violatingRoutes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallBlackHoleRouteDetectedViolation)) {
            return false;
        }
        NetworkFirewallBlackHoleRouteDetectedViolation other = (NetworkFirewallBlackHoleRouteDetectedViolation)obj;
        return Objects.equals(this.violationTarget(), other.violationTarget()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasViolatingRoutes() == other.hasViolatingRoutes() && Objects.equals(this.violatingRoutes(), other.violatingRoutes());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFirewallBlackHoleRouteDetectedViolation").add("ViolationTarget", (Object)this.violationTarget()).add("RouteTableId", (Object)this.routeTableId()).add("VpcId", (Object)this.vpcId()).add("ViolatingRoutes", this.hasViolatingRoutes() ? this.violatingRoutes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ViolationTarget": {
                return Optional.ofNullable(clazz.cast(this.violationTarget()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "ViolatingRoutes": {
                return Optional.ofNullable(clazz.cast(this.violatingRoutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ViolationTarget", VIOLATION_TARGET_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("ViolatingRoutes", VIOLATING_ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallBlackHoleRouteDetectedViolation, T> g) {
        return obj -> g.apply((NetworkFirewallBlackHoleRouteDetectedViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationTarget;
        private String routeTableId;
        private String vpcId;
        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallBlackHoleRouteDetectedViolation model) {
            this.violationTarget(model.violationTarget);
            this.routeTableId(model.routeTableId);
            this.vpcId(model.vpcId);
            this.violatingRoutes(model.violatingRoutes);
        }

        public final String getViolationTarget() {
            return this.violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route ... violatingRoutes) {
            this.violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder> ... violatingRoutes) {
            this.violatingRoutes(Stream.of(violatingRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NetworkFirewallBlackHoleRouteDetectedViolation build() {
            return new NetworkFirewallBlackHoleRouteDetectedViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFirewallBlackHoleRouteDetectedViolation> {
        public Builder violationTarget(String var1);

        public Builder routeTableId(String var1);

        public Builder vpcId(String var1);

        public Builder violatingRoutes(Collection<Route> var1);

        public Builder violatingRoutes(Route ... var1);

        public Builder violatingRoutes(Consumer<Route.Builder> ... var1);
    }
}

