/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.EntryType;
import software.amazon.awssdk.services.fms.model.NetworkAclEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntryDescription> {
    private static final SdkField<NetworkAclEntry> ENTRY_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntryDetail").getter(EntryDescription.getter(EntryDescription::entryDetail)).setter(EntryDescription.setter(Builder::entryDetail)).constructor(NetworkAclEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryDetail").build()}).build();
    private static final SdkField<Integer> ENTRY_RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EntryRuleNumber").getter(EntryDescription.getter(EntryDescription::entryRuleNumber)).setter(EntryDescription.setter(Builder::entryRuleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryRuleNumber").build()}).build();
    private static final SdkField<String> ENTRY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntryType").getter(EntryDescription.getter(EntryDescription::entryTypeAsString)).setter(EntryDescription.setter(Builder::entryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_DETAIL_FIELD, ENTRY_RULE_NUMBER_FIELD, ENTRY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EntryDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NetworkAclEntry entryDetail;
    private final Integer entryRuleNumber;
    private final String entryType;

    private EntryDescription(BuilderImpl builder) {
        this.entryDetail = builder.entryDetail;
        this.entryRuleNumber = builder.entryRuleNumber;
        this.entryType = builder.entryType;
    }

    public final NetworkAclEntry entryDetail() {
        return this.entryDetail;
    }

    public final Integer entryRuleNumber() {
        return this.entryRuleNumber;
    }

    public final EntryType entryType() {
        return EntryType.fromValue(this.entryType);
    }

    public final String entryTypeAsString() {
        return this.entryType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.entryRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.entryTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntryDescription)) {
            return false;
        }
        EntryDescription other = (EntryDescription)obj;
        return Objects.equals(this.entryDetail(), other.entryDetail()) && Objects.equals(this.entryRuleNumber(), other.entryRuleNumber()) && Objects.equals(this.entryTypeAsString(), other.entryTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EntryDescription").add("EntryDetail", (Object)this.entryDetail()).add("EntryRuleNumber", (Object)this.entryRuleNumber()).add("EntryType", (Object)this.entryTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntryDetail": {
                return Optional.ofNullable(clazz.cast(this.entryDetail()));
            }
            case "EntryRuleNumber": {
                return Optional.ofNullable(clazz.cast(this.entryRuleNumber()));
            }
            case "EntryType": {
                return Optional.ofNullable(clazz.cast(this.entryTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntryDetail", ENTRY_DETAIL_FIELD);
        map.put("EntryRuleNumber", ENTRY_RULE_NUMBER_FIELD);
        map.put("EntryType", ENTRY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntryDescription, T> g) {
        return obj -> g.apply((EntryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkAclEntry entryDetail;
        private Integer entryRuleNumber;
        private String entryType;

        private BuilderImpl() {
        }

        private BuilderImpl(EntryDescription model) {
            this.entryDetail(model.entryDetail);
            this.entryRuleNumber(model.entryRuleNumber);
            this.entryType(model.entryType);
        }

        public final NetworkAclEntry.Builder getEntryDetail() {
            return this.entryDetail != null ? this.entryDetail.toBuilder() : null;
        }

        public final void setEntryDetail(NetworkAclEntry.BuilderImpl entryDetail) {
            this.entryDetail = entryDetail != null ? entryDetail.build() : null;
        }

        @Override
        public final Builder entryDetail(NetworkAclEntry entryDetail) {
            this.entryDetail = entryDetail;
            return this;
        }

        public final Integer getEntryRuleNumber() {
            return this.entryRuleNumber;
        }

        public final void setEntryRuleNumber(Integer entryRuleNumber) {
            this.entryRuleNumber = entryRuleNumber;
        }

        @Override
        public final Builder entryRuleNumber(Integer entryRuleNumber) {
            this.entryRuleNumber = entryRuleNumber;
            return this;
        }

        public final String getEntryType() {
            return this.entryType;
        }

        public final void setEntryType(String entryType) {
            this.entryType = entryType;
        }

        @Override
        public final Builder entryType(String entryType) {
            this.entryType = entryType;
            return this;
        }

        @Override
        public final Builder entryType(EntryType entryType) {
            this.entryType(entryType == null ? null : entryType.toString());
            return this;
        }

        public EntryDescription build() {
            return new EntryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntryDescription> {
        public Builder entryDetail(NetworkAclEntry var1);

        default public Builder entryDetail(Consumer<NetworkAclEntry.Builder> entryDetail) {
            return this.entryDetail((NetworkAclEntry)((NetworkAclEntry.Builder)NetworkAclEntry.builder().applyMutation(entryDetail)).build());
        }

        public Builder entryRuleNumber(Integer var1);

        public Builder entryType(String var1);

        public Builder entryType(EntryType var1);
    }
}

