/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.ProtocolsListDataSummary;
import software.amazon.awssdk.services.fms.model.ProtocolsListsDataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProtocolsListsResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, ListProtocolsListsResponse> {
    private static final SdkField<List<ProtocolsListDataSummary>> PROTOCOLS_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtocolsLists").getter(ListProtocolsListsResponse.getter(ListProtocolsListsResponse::protocolsLists)).setter(ListProtocolsListsResponse.setter(Builder::protocolsLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolsLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtocolsListDataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProtocolsListsResponse.getter(ListProtocolsListsResponse::nextToken)).setter(ListProtocolsListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOLS_LISTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProtocolsListsResponse.memberNameToFieldInitializer();
    private final List<ProtocolsListDataSummary> protocolsLists;
    private final String nextToken;

    private ListProtocolsListsResponse(BuilderImpl builder) {
        super(builder);
        this.protocolsLists = builder.protocolsLists;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProtocolsLists() {
        return this.protocolsLists != null && !(this.protocolsLists instanceof SdkAutoConstructList);
    }

    public final List<ProtocolsListDataSummary> protocolsLists() {
        return this.protocolsLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocolsLists() ? this.protocolsLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtocolsListsResponse)) {
            return false;
        }
        ListProtocolsListsResponse other = (ListProtocolsListsResponse)((Object)obj);
        return this.hasProtocolsLists() == other.hasProtocolsLists() && Objects.equals(this.protocolsLists(), other.protocolsLists()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProtocolsListsResponse").add("ProtocolsLists", this.hasProtocolsLists() ? this.protocolsLists() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtocolsLists": {
                return Optional.ofNullable(clazz.cast(this.protocolsLists()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProtocolsLists", PROTOCOLS_LISTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProtocolsListsResponse, T> g) {
        return obj -> g.apply((ListProtocolsListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private List<ProtocolsListDataSummary> protocolsLists = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtocolsListsResponse model) {
            super(model);
            this.protocolsLists(model.protocolsLists);
            this.nextToken(model.nextToken);
        }

        public final List<ProtocolsListDataSummary.Builder> getProtocolsLists() {
            List<ProtocolsListDataSummary.Builder> result = ProtocolsListsDataCopier.copyToBuilder(this.protocolsLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtocolsLists(Collection<ProtocolsListDataSummary.BuilderImpl> protocolsLists) {
            this.protocolsLists = ProtocolsListsDataCopier.copyFromBuilder(protocolsLists);
        }

        @Override
        public final Builder protocolsLists(Collection<ProtocolsListDataSummary> protocolsLists) {
            this.protocolsLists = ProtocolsListsDataCopier.copy(protocolsLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsLists(ProtocolsListDataSummary ... protocolsLists) {
            this.protocolsLists(Arrays.asList(protocolsLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsLists(Consumer<ProtocolsListDataSummary.Builder> ... protocolsLists) {
            this.protocolsLists(Stream.of(protocolsLists).map(c -> (ProtocolsListDataSummary)((ProtocolsListDataSummary.Builder)ProtocolsListDataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProtocolsListsResponse build() {
            return new ListProtocolsListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProtocolsListsResponse> {
        public Builder protocolsLists(Collection<ProtocolsListDataSummary> var1);

        public Builder protocolsLists(ProtocolsListDataSummary ... var1);

        public Builder protocolsLists(Consumer<ProtocolsListDataSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

