/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.MarketplaceSubscriptionOnboardingStatus;
import software.amazon.awssdk.services.fms.model.ThirdPartyFirewallAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetThirdPartyFirewallAssociationStatusResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, GetThirdPartyFirewallAssociationStatusResponse> {
    private static final SdkField<String> THIRD_PARTY_FIREWALL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThirdPartyFirewallStatus").getter(GetThirdPartyFirewallAssociationStatusResponse.getter(GetThirdPartyFirewallAssociationStatusResponse::thirdPartyFirewallStatusAsString)).setter(GetThirdPartyFirewallAssociationStatusResponse.setter(Builder::thirdPartyFirewallStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallStatus").build()}).build();
    private static final SdkField<String> MARKETPLACE_ONBOARDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MarketplaceOnboardingStatus").getter(GetThirdPartyFirewallAssociationStatusResponse.getter(GetThirdPartyFirewallAssociationStatusResponse::marketplaceOnboardingStatusAsString)).setter(GetThirdPartyFirewallAssociationStatusResponse.setter(Builder::marketplaceOnboardingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceOnboardingStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THIRD_PARTY_FIREWALL_STATUS_FIELD, MARKETPLACE_ONBOARDING_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetThirdPartyFirewallAssociationStatusResponse.memberNameToFieldInitializer();
    private final String thirdPartyFirewallStatus;
    private final String marketplaceOnboardingStatus;

    private GetThirdPartyFirewallAssociationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.thirdPartyFirewallStatus = builder.thirdPartyFirewallStatus;
        this.marketplaceOnboardingStatus = builder.marketplaceOnboardingStatus;
    }

    public final ThirdPartyFirewallAssociationStatus thirdPartyFirewallStatus() {
        return ThirdPartyFirewallAssociationStatus.fromValue(this.thirdPartyFirewallStatus);
    }

    public final String thirdPartyFirewallStatusAsString() {
        return this.thirdPartyFirewallStatus;
    }

    public final MarketplaceSubscriptionOnboardingStatus marketplaceOnboardingStatus() {
        return MarketplaceSubscriptionOnboardingStatus.fromValue(this.marketplaceOnboardingStatus);
    }

    public final String marketplaceOnboardingStatusAsString() {
        return this.marketplaceOnboardingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thirdPartyFirewallStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketplaceOnboardingStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThirdPartyFirewallAssociationStatusResponse)) {
            return false;
        }
        GetThirdPartyFirewallAssociationStatusResponse other = (GetThirdPartyFirewallAssociationStatusResponse)((Object)obj);
        return Objects.equals(this.thirdPartyFirewallStatusAsString(), other.thirdPartyFirewallStatusAsString()) && Objects.equals(this.marketplaceOnboardingStatusAsString(), other.marketplaceOnboardingStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetThirdPartyFirewallAssociationStatusResponse").add("ThirdPartyFirewallStatus", (Object)this.thirdPartyFirewallStatusAsString()).add("MarketplaceOnboardingStatus", (Object)this.marketplaceOnboardingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThirdPartyFirewallStatus": {
                return Optional.ofNullable(clazz.cast(this.thirdPartyFirewallStatusAsString()));
            }
            case "MarketplaceOnboardingStatus": {
                return Optional.ofNullable(clazz.cast(this.marketplaceOnboardingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ThirdPartyFirewallStatus", THIRD_PARTY_FIREWALL_STATUS_FIELD);
        map.put("MarketplaceOnboardingStatus", MARKETPLACE_ONBOARDING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetThirdPartyFirewallAssociationStatusResponse, T> g) {
        return obj -> g.apply((GetThirdPartyFirewallAssociationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private String thirdPartyFirewallStatus;
        private String marketplaceOnboardingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThirdPartyFirewallAssociationStatusResponse model) {
            super(model);
            this.thirdPartyFirewallStatus(model.thirdPartyFirewallStatus);
            this.marketplaceOnboardingStatus(model.marketplaceOnboardingStatus);
        }

        public final String getThirdPartyFirewallStatus() {
            return this.thirdPartyFirewallStatus;
        }

        public final void setThirdPartyFirewallStatus(String thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus = thirdPartyFirewallStatus;
        }

        @Override
        public final Builder thirdPartyFirewallStatus(String thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus = thirdPartyFirewallStatus;
            return this;
        }

        @Override
        public final Builder thirdPartyFirewallStatus(ThirdPartyFirewallAssociationStatus thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus(thirdPartyFirewallStatus == null ? null : thirdPartyFirewallStatus.toString());
            return this;
        }

        public final String getMarketplaceOnboardingStatus() {
            return this.marketplaceOnboardingStatus;
        }

        public final void setMarketplaceOnboardingStatus(String marketplaceOnboardingStatus) {
            this.marketplaceOnboardingStatus = marketplaceOnboardingStatus;
        }

        @Override
        public final Builder marketplaceOnboardingStatus(String marketplaceOnboardingStatus) {
            this.marketplaceOnboardingStatus = marketplaceOnboardingStatus;
            return this;
        }

        @Override
        public final Builder marketplaceOnboardingStatus(MarketplaceSubscriptionOnboardingStatus marketplaceOnboardingStatus) {
            this.marketplaceOnboardingStatus(marketplaceOnboardingStatus == null ? null : marketplaceOnboardingStatus.toString());
            return this;
        }

        @Override
        public GetThirdPartyFirewallAssociationStatusResponse build() {
            return new GetThirdPartyFirewallAssociationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetThirdPartyFirewallAssociationStatusResponse> {
        public Builder thirdPartyFirewallStatus(String var1);

        public Builder thirdPartyFirewallStatus(ThirdPartyFirewallAssociationStatus var1);

        public Builder marketplaceOnboardingStatus(String var1);

        public Builder marketplaceOnboardingStatus(MarketplaceSubscriptionOnboardingStatus var1);
    }
}

