/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.Route;
import software.amazon.awssdk.services.fms.model.RoutesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteHasOutOfScopeEndpointViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteHasOutOfScopeEndpointViolation> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::subnetId)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::vpcId)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::routeTableId)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViolatingRoutes").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::violatingRoutes)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::violatingRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetAvailabilityZone").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::subnetAvailabilityZone)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::subnetAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build()}).build();
    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetAvailabilityZoneId").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::subnetAvailabilityZoneId)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::subnetAvailabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZoneId").build()}).build();
    private static final SdkField<String> CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentFirewallSubnetRouteTable").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::currentFirewallSubnetRouteTable)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::currentFirewallSubnetRouteTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFirewallSubnetRouteTable").build()}).build();
    private static final SdkField<String> FIREWALL_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallSubnetId").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::firewallSubnetId)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::firewallSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetId").build()}).build();
    private static final SdkField<List<Route>> FIREWALL_SUBNET_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FirewallSubnetRoutes").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::firewallSubnetRoutes)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::firewallSubnetRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetGatewayId").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::internetGatewayId)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::internetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayId").build()}).build();
    private static final SdkField<String> CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentInternetGatewayRouteTable").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::currentInternetGatewayRouteTable)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::currentInternetGatewayRouteTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInternetGatewayRouteTable").build()}).build();
    private static final SdkField<List<Route>> INTERNET_GATEWAY_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InternetGatewayRoutes").getter(RouteHasOutOfScopeEndpointViolation.getter(RouteHasOutOfScopeEndpointViolation::internetGatewayRoutes)).setter(RouteHasOutOfScopeEndpointViolation.setter(Builder::internetGatewayRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, VPC_ID_FIELD, ROUTE_TABLE_ID_FIELD, VIOLATING_ROUTES_FIELD, SUBNET_AVAILABILITY_ZONE_FIELD, SUBNET_AVAILABILITY_ZONE_ID_FIELD, CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD, FIREWALL_SUBNET_ID_FIELD, FIREWALL_SUBNET_ROUTES_FIELD, INTERNET_GATEWAY_ID_FIELD, CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD, INTERNET_GATEWAY_ROUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteHasOutOfScopeEndpointViolation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subnetId;
    private final String vpcId;
    private final String routeTableId;
    private final List<Route> violatingRoutes;
    private final String subnetAvailabilityZone;
    private final String subnetAvailabilityZoneId;
    private final String currentFirewallSubnetRouteTable;
    private final String firewallSubnetId;
    private final List<Route> firewallSubnetRoutes;
    private final String internetGatewayId;
    private final String currentInternetGatewayRouteTable;
    private final List<Route> internetGatewayRoutes;

    private RouteHasOutOfScopeEndpointViolation(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.routeTableId = builder.routeTableId;
        this.violatingRoutes = builder.violatingRoutes;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.subnetAvailabilityZoneId = builder.subnetAvailabilityZoneId;
        this.currentFirewallSubnetRouteTable = builder.currentFirewallSubnetRouteTable;
        this.firewallSubnetId = builder.firewallSubnetId;
        this.firewallSubnetRoutes = builder.firewallSubnetRoutes;
        this.internetGatewayId = builder.internetGatewayId;
        this.currentInternetGatewayRouteTable = builder.currentInternetGatewayRouteTable;
        this.internetGatewayRoutes = builder.internetGatewayRoutes;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final boolean hasViolatingRoutes() {
        return this.violatingRoutes != null && !(this.violatingRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> violatingRoutes() {
        return this.violatingRoutes;
    }

    public final String subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public final String subnetAvailabilityZoneId() {
        return this.subnetAvailabilityZoneId;
    }

    public final String currentFirewallSubnetRouteTable() {
        return this.currentFirewallSubnetRouteTable;
    }

    public final String firewallSubnetId() {
        return this.firewallSubnetId;
    }

    public final boolean hasFirewallSubnetRoutes() {
        return this.firewallSubnetRoutes != null && !(this.firewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> firewallSubnetRoutes() {
        return this.firewallSubnetRoutes;
    }

    public final String internetGatewayId() {
        return this.internetGatewayId;
    }

    public final String currentInternetGatewayRouteTable() {
        return this.currentInternetGatewayRouteTable;
    }

    public final boolean hasInternetGatewayRoutes() {
        return this.internetGatewayRoutes != null && !(this.internetGatewayRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> internetGatewayRoutes() {
        return this.internetGatewayRoutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViolatingRoutes() ? this.violatingRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentFirewallSubnetRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewallSubnetRoutes() ? this.firewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInternetGatewayRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInternetGatewayRoutes() ? this.internetGatewayRoutes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteHasOutOfScopeEndpointViolation)) {
            return false;
        }
        RouteHasOutOfScopeEndpointViolation other = (RouteHasOutOfScopeEndpointViolation)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.routeTableId(), other.routeTableId()) && this.hasViolatingRoutes() == other.hasViolatingRoutes() && Objects.equals(this.violatingRoutes(), other.violatingRoutes()) && Objects.equals(this.subnetAvailabilityZone(), other.subnetAvailabilityZone()) && Objects.equals(this.subnetAvailabilityZoneId(), other.subnetAvailabilityZoneId()) && Objects.equals(this.currentFirewallSubnetRouteTable(), other.currentFirewallSubnetRouteTable()) && Objects.equals(this.firewallSubnetId(), other.firewallSubnetId()) && this.hasFirewallSubnetRoutes() == other.hasFirewallSubnetRoutes() && Objects.equals(this.firewallSubnetRoutes(), other.firewallSubnetRoutes()) && Objects.equals(this.internetGatewayId(), other.internetGatewayId()) && Objects.equals(this.currentInternetGatewayRouteTable(), other.currentInternetGatewayRouteTable()) && this.hasInternetGatewayRoutes() == other.hasInternetGatewayRoutes() && Objects.equals(this.internetGatewayRoutes(), other.internetGatewayRoutes());
    }

    public final String toString() {
        return ToString.builder((String)"RouteHasOutOfScopeEndpointViolation").add("SubnetId", (Object)this.subnetId()).add("VpcId", (Object)this.vpcId()).add("RouteTableId", (Object)this.routeTableId()).add("ViolatingRoutes", this.hasViolatingRoutes() ? this.violatingRoutes() : null).add("SubnetAvailabilityZone", (Object)this.subnetAvailabilityZone()).add("SubnetAvailabilityZoneId", (Object)this.subnetAvailabilityZoneId()).add("CurrentFirewallSubnetRouteTable", (Object)this.currentFirewallSubnetRouteTable()).add("FirewallSubnetId", (Object)this.firewallSubnetId()).add("FirewallSubnetRoutes", this.hasFirewallSubnetRoutes() ? this.firewallSubnetRoutes() : null).add("InternetGatewayId", (Object)this.internetGatewayId()).add("CurrentInternetGatewayRouteTable", (Object)this.currentInternetGatewayRouteTable()).add("InternetGatewayRoutes", this.hasInternetGatewayRoutes() ? this.internetGatewayRoutes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "ViolatingRoutes": {
                return Optional.ofNullable(clazz.cast(this.violatingRoutes()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.subnetAvailabilityZone()));
            }
            case "SubnetAvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.subnetAvailabilityZoneId()));
            }
            case "CurrentFirewallSubnetRouteTable": {
                return Optional.ofNullable(clazz.cast(this.currentFirewallSubnetRouteTable()));
            }
            case "FirewallSubnetId": {
                return Optional.ofNullable(clazz.cast(this.firewallSubnetId()));
            }
            case "FirewallSubnetRoutes": {
                return Optional.ofNullable(clazz.cast(this.firewallSubnetRoutes()));
            }
            case "InternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayId()));
            }
            case "CurrentInternetGatewayRouteTable": {
                return Optional.ofNullable(clazz.cast(this.currentInternetGatewayRouteTable()));
            }
            case "InternetGatewayRoutes": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayRoutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("ViolatingRoutes", VIOLATING_ROUTES_FIELD);
        map.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
        map.put("SubnetAvailabilityZoneId", SUBNET_AVAILABILITY_ZONE_ID_FIELD);
        map.put("CurrentFirewallSubnetRouteTable", CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD);
        map.put("FirewallSubnetId", FIREWALL_SUBNET_ID_FIELD);
        map.put("FirewallSubnetRoutes", FIREWALL_SUBNET_ROUTES_FIELD);
        map.put("InternetGatewayId", INTERNET_GATEWAY_ID_FIELD);
        map.put("CurrentInternetGatewayRouteTable", CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD);
        map.put("InternetGatewayRoutes", INTERNET_GATEWAY_ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteHasOutOfScopeEndpointViolation, T> g) {
        return obj -> g.apply((RouteHasOutOfScopeEndpointViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private String vpcId;
        private String routeTableId;
        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();
        private String subnetAvailabilityZone;
        private String subnetAvailabilityZoneId;
        private String currentFirewallSubnetRouteTable;
        private String firewallSubnetId;
        private List<Route> firewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();
        private String internetGatewayId;
        private String currentInternetGatewayRouteTable;
        private List<Route> internetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteHasOutOfScopeEndpointViolation model) {
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.routeTableId(model.routeTableId);
            this.violatingRoutes(model.violatingRoutes);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
            this.subnetAvailabilityZoneId(model.subnetAvailabilityZoneId);
            this.currentFirewallSubnetRouteTable(model.currentFirewallSubnetRouteTable);
            this.firewallSubnetId(model.firewallSubnetId);
            this.firewallSubnetRoutes(model.firewallSubnetRoutes);
            this.internetGatewayId(model.internetGatewayId);
            this.currentInternetGatewayRouteTable(model.currentInternetGatewayRouteTable);
            this.internetGatewayRoutes(model.internetGatewayRoutes);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route ... violatingRoutes) {
            this.violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder> ... violatingRoutes) {
            this.violatingRoutes(Stream.of(violatingRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone;
        }

        public final void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getSubnetAvailabilityZoneId() {
            return this.subnetAvailabilityZoneId;
        }

        public final void setSubnetAvailabilityZoneId(String subnetAvailabilityZoneId) {
            this.subnetAvailabilityZoneId = subnetAvailabilityZoneId;
        }

        @Override
        public final Builder subnetAvailabilityZoneId(String subnetAvailabilityZoneId) {
            this.subnetAvailabilityZoneId = subnetAvailabilityZoneId;
            return this;
        }

        public final String getCurrentFirewallSubnetRouteTable() {
            return this.currentFirewallSubnetRouteTable;
        }

        public final void setCurrentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
        }

        @Override
        public final Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
            return this;
        }

        public final String getFirewallSubnetId() {
            return this.firewallSubnetId;
        }

        public final void setFirewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
        }

        @Override
        public final Builder firewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
            return this;
        }

        public final List<Route.Builder> getFirewallSubnetRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.firewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallSubnetRoutes(Collection<Route.BuilderImpl> firewallSubnetRoutes) {
            this.firewallSubnetRoutes = RoutesCopier.copyFromBuilder(firewallSubnetRoutes);
        }

        @Override
        public final Builder firewallSubnetRoutes(Collection<Route> firewallSubnetRoutes) {
            this.firewallSubnetRoutes = RoutesCopier.copy(firewallSubnetRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallSubnetRoutes(Route ... firewallSubnetRoutes) {
            this.firewallSubnetRoutes(Arrays.asList(firewallSubnetRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallSubnetRoutes(Consumer<Route.Builder> ... firewallSubnetRoutes) {
            this.firewallSubnetRoutes(Stream.of(firewallSubnetRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final String getCurrentInternetGatewayRouteTable() {
            return this.currentInternetGatewayRouteTable;
        }

        public final void setCurrentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
        }

        @Override
        public final Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
            return this;
        }

        public final List<Route.Builder> getInternetGatewayRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.internetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInternetGatewayRoutes(Collection<Route.BuilderImpl> internetGatewayRoutes) {
            this.internetGatewayRoutes = RoutesCopier.copyFromBuilder(internetGatewayRoutes);
        }

        @Override
        public final Builder internetGatewayRoutes(Collection<Route> internetGatewayRoutes) {
            this.internetGatewayRoutes = RoutesCopier.copy(internetGatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGatewayRoutes(Route ... internetGatewayRoutes) {
            this.internetGatewayRoutes(Arrays.asList(internetGatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGatewayRoutes(Consumer<Route.Builder> ... internetGatewayRoutes) {
            this.internetGatewayRoutes(Stream.of(internetGatewayRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RouteHasOutOfScopeEndpointViolation build() {
            return new RouteHasOutOfScopeEndpointViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteHasOutOfScopeEndpointViolation> {
        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder routeTableId(String var1);

        public Builder violatingRoutes(Collection<Route> var1);

        public Builder violatingRoutes(Route ... var1);

        public Builder violatingRoutes(Consumer<Route.Builder> ... var1);

        public Builder subnetAvailabilityZone(String var1);

        public Builder subnetAvailabilityZoneId(String var1);

        public Builder currentFirewallSubnetRouteTable(String var1);

        public Builder firewallSubnetId(String var1);

        public Builder firewallSubnetRoutes(Collection<Route> var1);

        public Builder firewallSubnetRoutes(Route ... var1);

        public Builder firewallSubnetRoutes(Consumer<Route.Builder> ... var1);

        public Builder internetGatewayId(String var1);

        public Builder currentInternetGatewayRouteTable(String var1);

        public Builder internetGatewayRoutes(Collection<Route> var1);

        public Builder internetGatewayRoutes(Route ... var1);

        public Builder internetGatewayRoutes(Consumer<Route.Builder> ... var1);
    }
}

