/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.TargetViolationReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartialMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartialMatch> {
    private static final SdkField<String> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reference").getter(PartialMatch.getter(PartialMatch::reference)).setter(PartialMatch.setter(Builder::reference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reference").build()}).build();
    private static final SdkField<List<String>> TARGET_VIOLATION_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetViolationReasons").getter(PartialMatch.getter(PartialMatch::targetViolationReasons)).setter(PartialMatch.setter(Builder::targetViolationReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetViolationReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_FIELD, TARGET_VIOLATION_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PartialMatch.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reference;
    private final List<String> targetViolationReasons;

    private PartialMatch(BuilderImpl builder) {
        this.reference = builder.reference;
        this.targetViolationReasons = builder.targetViolationReasons;
    }

    public final String reference() {
        return this.reference;
    }

    public final boolean hasTargetViolationReasons() {
        return this.targetViolationReasons != null && !(this.targetViolationReasons instanceof SdkAutoConstructList);
    }

    public final List<String> targetViolationReasons() {
        return this.targetViolationReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetViolationReasons() ? this.targetViolationReasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartialMatch)) {
            return false;
        }
        PartialMatch other = (PartialMatch)obj;
        return Objects.equals(this.reference(), other.reference()) && this.hasTargetViolationReasons() == other.hasTargetViolationReasons() && Objects.equals(this.targetViolationReasons(), other.targetViolationReasons());
    }

    public final String toString() {
        return ToString.builder((String)"PartialMatch").add("Reference", (Object)this.reference()).add("TargetViolationReasons", this.hasTargetViolationReasons() ? this.targetViolationReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "TargetViolationReasons": {
                return Optional.ofNullable(clazz.cast(this.targetViolationReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Reference", REFERENCE_FIELD);
        map.put("TargetViolationReasons", TARGET_VIOLATION_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartialMatch, T> g) {
        return obj -> g.apply((PartialMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reference;
        private List<String> targetViolationReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartialMatch model) {
            this.reference(model.reference);
            this.targetViolationReasons(model.targetViolationReasons);
        }

        public final String getReference() {
            return this.reference;
        }

        public final void setReference(String reference) {
            this.reference = reference;
        }

        @Override
        public final Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public final Collection<String> getTargetViolationReasons() {
            if (this.targetViolationReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetViolationReasons;
        }

        public final void setTargetViolationReasons(Collection<String> targetViolationReasons) {
            this.targetViolationReasons = TargetViolationReasonsCopier.copy(targetViolationReasons);
        }

        @Override
        public final Builder targetViolationReasons(Collection<String> targetViolationReasons) {
            this.targetViolationReasons = TargetViolationReasonsCopier.copy(targetViolationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetViolationReasons(String ... targetViolationReasons) {
            this.targetViolationReasons(Arrays.asList(targetViolationReasons));
            return this;
        }

        public PartialMatch build() {
            return new PartialMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartialMatch> {
        public Builder reference(String var1);

        public Builder targetViolationReasons(Collection<String> var1);

        public Builder targetViolationReasons(String ... var1);
    }
}

