/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AccountRoleStatus;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAdminAccountResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, GetAdminAccountResponse> {
    private static final SdkField<String> ADMIN_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdminAccount").getter(GetAdminAccountResponse.getter(GetAdminAccountResponse::adminAccount)).setter(GetAdminAccountResponse.setter(Builder::adminAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccount").build()}).build();
    private static final SdkField<String> ROLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleStatus").getter(GetAdminAccountResponse.getter(GetAdminAccountResponse::roleStatusAsString)).setter(GetAdminAccountResponse.setter(Builder::roleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_FIELD, ROLE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAdminAccountResponse.memberNameToFieldInitializer();
    private final String adminAccount;
    private final String roleStatus;

    private GetAdminAccountResponse(BuilderImpl builder) {
        super(builder);
        this.adminAccount = builder.adminAccount;
        this.roleStatus = builder.roleStatus;
    }

    public final String adminAccount() {
        return this.adminAccount;
    }

    public final AccountRoleStatus roleStatus() {
        return AccountRoleStatus.fromValue(this.roleStatus);
    }

    public final String roleStatusAsString() {
        return this.roleStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdminAccountResponse)) {
            return false;
        }
        GetAdminAccountResponse other = (GetAdminAccountResponse)((Object)obj);
        return Objects.equals(this.adminAccount(), other.adminAccount()) && Objects.equals(this.roleStatusAsString(), other.roleStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAdminAccountResponse").add("AdminAccount", (Object)this.adminAccount()).add("RoleStatus", (Object)this.roleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminAccount": {
                return Optional.ofNullable(clazz.cast(this.adminAccount()));
            }
            case "RoleStatus": {
                return Optional.ofNullable(clazz.cast(this.roleStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AdminAccount", ADMIN_ACCOUNT_FIELD);
        map.put("RoleStatus", ROLE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAdminAccountResponse, T> g) {
        return obj -> g.apply((GetAdminAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private String adminAccount;
        private String roleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAdminAccountResponse model) {
            super(model);
            this.adminAccount(model.adminAccount);
            this.roleStatus(model.roleStatus);
        }

        public final String getAdminAccount() {
            return this.adminAccount;
        }

        public final void setAdminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
        }

        @Override
        public final Builder adminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
            return this;
        }

        public final String getRoleStatus() {
            return this.roleStatus;
        }

        public final void setRoleStatus(String roleStatus) {
            this.roleStatus = roleStatus;
        }

        @Override
        public final Builder roleStatus(String roleStatus) {
            this.roleStatus = roleStatus;
            return this;
        }

        @Override
        public final Builder roleStatus(AccountRoleStatus roleStatus) {
            this.roleStatus(roleStatus == null ? null : roleStatus.toString());
            return this;
        }

        @Override
        public GetAdminAccountResponse build() {
            return new GetAdminAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAdminAccountResponse> {
        public Builder adminAccount(String var1);

        public Builder roleStatus(String var1);

        public Builder roleStatus(AccountRoleStatus var1);
    }
}

