/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.ActionTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkAclAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateNetworkAclAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateNetworkAclAction.getter(CreateNetworkAclAction::description)).setter(CreateNetworkAclAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ActionTarget> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(CreateNetworkAclAction.getter(CreateNetworkAclAction::vpc)).setter(CreateNetworkAclAction.setter(Builder::vpc)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()}).build();
    private static final SdkField<Boolean> FMS_CAN_REMEDIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FMSCanRemediate").getter(CreateNetworkAclAction.getter(CreateNetworkAclAction::fmsCanRemediate)).setter(CreateNetworkAclAction.setter(Builder::fmsCanRemediate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FMSCanRemediate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, VPC_FIELD, FMS_CAN_REMEDIATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNetworkAclAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final ActionTarget vpc;
    private final Boolean fmsCanRemediate;

    private CreateNetworkAclAction(BuilderImpl builder) {
        this.description = builder.description;
        this.vpc = builder.vpc;
        this.fmsCanRemediate = builder.fmsCanRemediate;
    }

    public final String description() {
        return this.description;
    }

    public final ActionTarget vpc() {
        return this.vpc;
    }

    public final Boolean fmsCanRemediate() {
        return this.fmsCanRemediate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.fmsCanRemediate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAclAction)) {
            return false;
        }
        CreateNetworkAclAction other = (CreateNetworkAclAction)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.fmsCanRemediate(), other.fmsCanRemediate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkAclAction").add("Description", (Object)this.description()).add("Vpc", (Object)this.vpc()).add("FMSCanRemediate", (Object)this.fmsCanRemediate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "FMSCanRemediate": {
                return Optional.ofNullable(clazz.cast(this.fmsCanRemediate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Vpc", VPC_FIELD);
        map.put("FMSCanRemediate", FMS_CAN_REMEDIATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkAclAction, T> g) {
        return obj -> g.apply((CreateNetworkAclAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private ActionTarget vpc;
        private Boolean fmsCanRemediate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAclAction model) {
            this.description(model.description);
            this.vpc(model.vpc);
            this.fmsCanRemediate(model.fmsCanRemediate);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(ActionTarget.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(ActionTarget vpc) {
            this.vpc = vpc;
            return this;
        }

        public final Boolean getFmsCanRemediate() {
            return this.fmsCanRemediate;
        }

        public final void setFmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
        }

        @Override
        public final Builder fmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
            return this;
        }

        public CreateNetworkAclAction build() {
            return new CreateNetworkAclAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateNetworkAclAction> {
        public Builder description(String var1);

        public Builder vpc(ActionTarget var1);

        default public Builder vpc(Consumer<ActionTarget.Builder> vpc) {
            return this.vpc((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(vpc)).build());
        }

        public Builder fmsCanRemediate(Boolean var1);
    }
}

