/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.AccountIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountScope> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accounts").getter(AccountScope.getter(AccountScope::accounts)).setter(AccountScope.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_ACCOUNTS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllAccountsEnabled").getter(AccountScope.getter(AccountScope::allAccountsEnabled)).setter(AccountScope.setter(Builder::allAccountsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllAccountsEnabled").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_SPECIFIED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeSpecifiedAccounts").getter(AccountScope.getter(AccountScope::excludeSpecifiedAccounts)).setter(AccountScope.setter(Builder::excludeSpecifiedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeSpecifiedAccounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, ALL_ACCOUNTS_ENABLED_FIELD, EXCLUDE_SPECIFIED_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Accounts", ACCOUNTS_FIELD);
            this.put("AllAccountsEnabled", ALL_ACCOUNTS_ENABLED_FIELD);
            this.put("ExcludeSpecifiedAccounts", EXCLUDE_SPECIFIED_ACCOUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> accounts;
    private final Boolean allAccountsEnabled;
    private final Boolean excludeSpecifiedAccounts;

    private AccountScope(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.allAccountsEnabled = builder.allAccountsEnabled;
        this.excludeSpecifiedAccounts = builder.excludeSpecifiedAccounts;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<String> accounts() {
        return this.accounts;
    }

    public final Boolean allAccountsEnabled() {
        return this.allAccountsEnabled;
    }

    public final Boolean excludeSpecifiedAccounts() {
        return this.excludeSpecifiedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allAccountsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeSpecifiedAccounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountScope)) {
            return false;
        }
        AccountScope other = (AccountScope)obj;
        return this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && Objects.equals(this.allAccountsEnabled(), other.allAccountsEnabled()) && Objects.equals(this.excludeSpecifiedAccounts(), other.excludeSpecifiedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"AccountScope").add("Accounts", this.hasAccounts() ? this.accounts() : null).add("AllAccountsEnabled", (Object)this.allAccountsEnabled()).add("ExcludeSpecifiedAccounts", (Object)this.excludeSpecifiedAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "AllAccountsEnabled": {
                return Optional.ofNullable(clazz.cast(this.allAccountsEnabled()));
            }
            case "ExcludeSpecifiedAccounts": {
                return Optional.ofNullable(clazz.cast(this.excludeSpecifiedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountScope, T> g) {
        return obj -> g.apply((AccountScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();
        private Boolean allAccountsEnabled;
        private Boolean excludeSpecifiedAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountScope model) {
            this.accounts(model.accounts);
            this.allAccountsEnabled(model.allAccountsEnabled);
            this.excludeSpecifiedAccounts(model.excludeSpecifiedAccounts);
        }

        public final Collection<String> getAccounts() {
            if (this.accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountIdListCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountIdListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public final Boolean getAllAccountsEnabled() {
            return this.allAccountsEnabled;
        }

        public final void setAllAccountsEnabled(Boolean allAccountsEnabled) {
            this.allAccountsEnabled = allAccountsEnabled;
        }

        @Override
        public final Builder allAccountsEnabled(Boolean allAccountsEnabled) {
            this.allAccountsEnabled = allAccountsEnabled;
            return this;
        }

        public final Boolean getExcludeSpecifiedAccounts() {
            return this.excludeSpecifiedAccounts;
        }

        public final void setExcludeSpecifiedAccounts(Boolean excludeSpecifiedAccounts) {
            this.excludeSpecifiedAccounts = excludeSpecifiedAccounts;
        }

        @Override
        public final Builder excludeSpecifiedAccounts(Boolean excludeSpecifiedAccounts) {
            this.excludeSpecifiedAccounts = excludeSpecifiedAccounts;
            return this;
        }

        public AccountScope build() {
            return new AccountScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountScope> {
        public Builder accounts(Collection<String> var1);

        public Builder accounts(String ... var1);

        public Builder allAccountsEnabled(Boolean var1);

        public Builder excludeSpecifiedAccounts(Boolean var1);
    }
}

