/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.CreateNetworkAclAction;
import software.amazon.awssdk.services.fms.model.CreateNetworkAclEntriesAction;
import software.amazon.awssdk.services.fms.model.DeleteNetworkAclEntriesAction;
import software.amazon.awssdk.services.fms.model.EC2AssociateRouteTableAction;
import software.amazon.awssdk.services.fms.model.EC2CopyRouteTableAction;
import software.amazon.awssdk.services.fms.model.EC2CreateRouteAction;
import software.amazon.awssdk.services.fms.model.EC2CreateRouteTableAction;
import software.amazon.awssdk.services.fms.model.EC2DeleteRouteAction;
import software.amazon.awssdk.services.fms.model.EC2ReplaceRouteAction;
import software.amazon.awssdk.services.fms.model.EC2ReplaceRouteTableAssociationAction;
import software.amazon.awssdk.services.fms.model.FMSPolicyUpdateFirewallCreationConfigAction;
import software.amazon.awssdk.services.fms.model.ReplaceNetworkAclAssociationAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemediationAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemediationAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RemediationAction.getter(RemediationAction::description)).setter(RemediationAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<EC2CreateRouteAction> EC2_CREATE_ROUTE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2CreateRouteAction").getter(RemediationAction.getter(RemediationAction::ec2CreateRouteAction)).setter(RemediationAction.setter(Builder::ec2CreateRouteAction)).constructor(EC2CreateRouteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2CreateRouteAction").build()}).build();
    private static final SdkField<EC2ReplaceRouteAction> EC2_REPLACE_ROUTE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2ReplaceRouteAction").getter(RemediationAction.getter(RemediationAction::ec2ReplaceRouteAction)).setter(RemediationAction.setter(Builder::ec2ReplaceRouteAction)).constructor(EC2ReplaceRouteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ReplaceRouteAction").build()}).build();
    private static final SdkField<EC2DeleteRouteAction> EC2_DELETE_ROUTE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2DeleteRouteAction").getter(RemediationAction.getter(RemediationAction::ec2DeleteRouteAction)).setter(RemediationAction.setter(Builder::ec2DeleteRouteAction)).constructor(EC2DeleteRouteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2DeleteRouteAction").build()}).build();
    private static final SdkField<EC2CopyRouteTableAction> EC2_COPY_ROUTE_TABLE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2CopyRouteTableAction").getter(RemediationAction.getter(RemediationAction::ec2CopyRouteTableAction)).setter(RemediationAction.setter(Builder::ec2CopyRouteTableAction)).constructor(EC2CopyRouteTableAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2CopyRouteTableAction").build()}).build();
    private static final SdkField<EC2ReplaceRouteTableAssociationAction> EC2_REPLACE_ROUTE_TABLE_ASSOCIATION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2ReplaceRouteTableAssociationAction").getter(RemediationAction.getter(RemediationAction::ec2ReplaceRouteTableAssociationAction)).setter(RemediationAction.setter(Builder::ec2ReplaceRouteTableAssociationAction)).constructor(EC2ReplaceRouteTableAssociationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ReplaceRouteTableAssociationAction").build()}).build();
    private static final SdkField<EC2AssociateRouteTableAction> EC2_ASSOCIATE_ROUTE_TABLE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2AssociateRouteTableAction").getter(RemediationAction.getter(RemediationAction::ec2AssociateRouteTableAction)).setter(RemediationAction.setter(Builder::ec2AssociateRouteTableAction)).constructor(EC2AssociateRouteTableAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2AssociateRouteTableAction").build()}).build();
    private static final SdkField<EC2CreateRouteTableAction> EC2_CREATE_ROUTE_TABLE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2CreateRouteTableAction").getter(RemediationAction.getter(RemediationAction::ec2CreateRouteTableAction)).setter(RemediationAction.setter(Builder::ec2CreateRouteTableAction)).constructor(EC2CreateRouteTableAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2CreateRouteTableAction").build()}).build();
    private static final SdkField<FMSPolicyUpdateFirewallCreationConfigAction> FMS_POLICY_UPDATE_FIREWALL_CREATION_CONFIG_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FMSPolicyUpdateFirewallCreationConfigAction").getter(RemediationAction.getter(RemediationAction::fmsPolicyUpdateFirewallCreationConfigAction)).setter(RemediationAction.setter(Builder::fmsPolicyUpdateFirewallCreationConfigAction)).constructor(FMSPolicyUpdateFirewallCreationConfigAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FMSPolicyUpdateFirewallCreationConfigAction").build()}).build();
    private static final SdkField<CreateNetworkAclAction> CREATE_NETWORK_ACL_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateNetworkAclAction").getter(RemediationAction.getter(RemediationAction::createNetworkAclAction)).setter(RemediationAction.setter(Builder::createNetworkAclAction)).constructor(CreateNetworkAclAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateNetworkAclAction").build()}).build();
    private static final SdkField<ReplaceNetworkAclAssociationAction> REPLACE_NETWORK_ACL_ASSOCIATION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplaceNetworkAclAssociationAction").getter(RemediationAction.getter(RemediationAction::replaceNetworkAclAssociationAction)).setter(RemediationAction.setter(Builder::replaceNetworkAclAssociationAction)).constructor(ReplaceNetworkAclAssociationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceNetworkAclAssociationAction").build()}).build();
    private static final SdkField<CreateNetworkAclEntriesAction> CREATE_NETWORK_ACL_ENTRIES_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateNetworkAclEntriesAction").getter(RemediationAction.getter(RemediationAction::createNetworkAclEntriesAction)).setter(RemediationAction.setter(Builder::createNetworkAclEntriesAction)).constructor(CreateNetworkAclEntriesAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateNetworkAclEntriesAction").build()}).build();
    private static final SdkField<DeleteNetworkAclEntriesAction> DELETE_NETWORK_ACL_ENTRIES_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeleteNetworkAclEntriesAction").getter(RemediationAction.getter(RemediationAction::deleteNetworkAclEntriesAction)).setter(RemediationAction.setter(Builder::deleteNetworkAclEntriesAction)).constructor(DeleteNetworkAclEntriesAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteNetworkAclEntriesAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EC2_CREATE_ROUTE_ACTION_FIELD, EC2_REPLACE_ROUTE_ACTION_FIELD, EC2_DELETE_ROUTE_ACTION_FIELD, EC2_COPY_ROUTE_TABLE_ACTION_FIELD, EC2_REPLACE_ROUTE_TABLE_ASSOCIATION_ACTION_FIELD, EC2_ASSOCIATE_ROUTE_TABLE_ACTION_FIELD, EC2_CREATE_ROUTE_TABLE_ACTION_FIELD, FMS_POLICY_UPDATE_FIREWALL_CREATION_CONFIG_ACTION_FIELD, CREATE_NETWORK_ACL_ACTION_FIELD, REPLACE_NETWORK_ACL_ASSOCIATION_ACTION_FIELD, CREATE_NETWORK_ACL_ENTRIES_ACTION_FIELD, DELETE_NETWORK_ACL_ENTRIES_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final EC2CreateRouteAction ec2CreateRouteAction;
    private final EC2ReplaceRouteAction ec2ReplaceRouteAction;
    private final EC2DeleteRouteAction ec2DeleteRouteAction;
    private final EC2CopyRouteTableAction ec2CopyRouteTableAction;
    private final EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction;
    private final EC2AssociateRouteTableAction ec2AssociateRouteTableAction;
    private final EC2CreateRouteTableAction ec2CreateRouteTableAction;
    private final FMSPolicyUpdateFirewallCreationConfigAction fmsPolicyUpdateFirewallCreationConfigAction;
    private final CreateNetworkAclAction createNetworkAclAction;
    private final ReplaceNetworkAclAssociationAction replaceNetworkAclAssociationAction;
    private final CreateNetworkAclEntriesAction createNetworkAclEntriesAction;
    private final DeleteNetworkAclEntriesAction deleteNetworkAclEntriesAction;

    private RemediationAction(BuilderImpl builder) {
        this.description = builder.description;
        this.ec2CreateRouteAction = builder.ec2CreateRouteAction;
        this.ec2ReplaceRouteAction = builder.ec2ReplaceRouteAction;
        this.ec2DeleteRouteAction = builder.ec2DeleteRouteAction;
        this.ec2CopyRouteTableAction = builder.ec2CopyRouteTableAction;
        this.ec2ReplaceRouteTableAssociationAction = builder.ec2ReplaceRouteTableAssociationAction;
        this.ec2AssociateRouteTableAction = builder.ec2AssociateRouteTableAction;
        this.ec2CreateRouteTableAction = builder.ec2CreateRouteTableAction;
        this.fmsPolicyUpdateFirewallCreationConfigAction = builder.fmsPolicyUpdateFirewallCreationConfigAction;
        this.createNetworkAclAction = builder.createNetworkAclAction;
        this.replaceNetworkAclAssociationAction = builder.replaceNetworkAclAssociationAction;
        this.createNetworkAclEntriesAction = builder.createNetworkAclEntriesAction;
        this.deleteNetworkAclEntriesAction = builder.deleteNetworkAclEntriesAction;
    }

    public final String description() {
        return this.description;
    }

    public final EC2CreateRouteAction ec2CreateRouteAction() {
        return this.ec2CreateRouteAction;
    }

    public final EC2ReplaceRouteAction ec2ReplaceRouteAction() {
        return this.ec2ReplaceRouteAction;
    }

    public final EC2DeleteRouteAction ec2DeleteRouteAction() {
        return this.ec2DeleteRouteAction;
    }

    public final EC2CopyRouteTableAction ec2CopyRouteTableAction() {
        return this.ec2CopyRouteTableAction;
    }

    public final EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction() {
        return this.ec2ReplaceRouteTableAssociationAction;
    }

    public final EC2AssociateRouteTableAction ec2AssociateRouteTableAction() {
        return this.ec2AssociateRouteTableAction;
    }

    public final EC2CreateRouteTableAction ec2CreateRouteTableAction() {
        return this.ec2CreateRouteTableAction;
    }

    public final FMSPolicyUpdateFirewallCreationConfigAction fmsPolicyUpdateFirewallCreationConfigAction() {
        return this.fmsPolicyUpdateFirewallCreationConfigAction;
    }

    public final CreateNetworkAclAction createNetworkAclAction() {
        return this.createNetworkAclAction;
    }

    public final ReplaceNetworkAclAssociationAction replaceNetworkAclAssociationAction() {
        return this.replaceNetworkAclAssociationAction;
    }

    public final CreateNetworkAclEntriesAction createNetworkAclEntriesAction() {
        return this.createNetworkAclEntriesAction;
    }

    public final DeleteNetworkAclEntriesAction deleteNetworkAclEntriesAction() {
        return this.deleteNetworkAclEntriesAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2CreateRouteAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ReplaceRouteAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2DeleteRouteAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2CopyRouteTableAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ReplaceRouteTableAssociationAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2AssociateRouteTableAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2CreateRouteTableAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.fmsPolicyUpdateFirewallCreationConfigAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.createNetworkAclAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceNetworkAclAssociationAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.createNetworkAclEntriesAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteNetworkAclEntriesAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationAction)) {
            return false;
        }
        RemediationAction other = (RemediationAction)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.ec2CreateRouteAction(), other.ec2CreateRouteAction()) && Objects.equals(this.ec2ReplaceRouteAction(), other.ec2ReplaceRouteAction()) && Objects.equals(this.ec2DeleteRouteAction(), other.ec2DeleteRouteAction()) && Objects.equals(this.ec2CopyRouteTableAction(), other.ec2CopyRouteTableAction()) && Objects.equals(this.ec2ReplaceRouteTableAssociationAction(), other.ec2ReplaceRouteTableAssociationAction()) && Objects.equals(this.ec2AssociateRouteTableAction(), other.ec2AssociateRouteTableAction()) && Objects.equals(this.ec2CreateRouteTableAction(), other.ec2CreateRouteTableAction()) && Objects.equals(this.fmsPolicyUpdateFirewallCreationConfigAction(), other.fmsPolicyUpdateFirewallCreationConfigAction()) && Objects.equals(this.createNetworkAclAction(), other.createNetworkAclAction()) && Objects.equals(this.replaceNetworkAclAssociationAction(), other.replaceNetworkAclAssociationAction()) && Objects.equals(this.createNetworkAclEntriesAction(), other.createNetworkAclEntriesAction()) && Objects.equals(this.deleteNetworkAclEntriesAction(), other.deleteNetworkAclEntriesAction());
    }

    public final String toString() {
        return ToString.builder((String)"RemediationAction").add("Description", (Object)this.description()).add("EC2CreateRouteAction", (Object)this.ec2CreateRouteAction()).add("EC2ReplaceRouteAction", (Object)this.ec2ReplaceRouteAction()).add("EC2DeleteRouteAction", (Object)this.ec2DeleteRouteAction()).add("EC2CopyRouteTableAction", (Object)this.ec2CopyRouteTableAction()).add("EC2ReplaceRouteTableAssociationAction", (Object)this.ec2ReplaceRouteTableAssociationAction()).add("EC2AssociateRouteTableAction", (Object)this.ec2AssociateRouteTableAction()).add("EC2CreateRouteTableAction", (Object)this.ec2CreateRouteTableAction()).add("FMSPolicyUpdateFirewallCreationConfigAction", (Object)this.fmsPolicyUpdateFirewallCreationConfigAction()).add("CreateNetworkAclAction", (Object)this.createNetworkAclAction()).add("ReplaceNetworkAclAssociationAction", (Object)this.replaceNetworkAclAssociationAction()).add("CreateNetworkAclEntriesAction", (Object)this.createNetworkAclEntriesAction()).add("DeleteNetworkAclEntriesAction", (Object)this.deleteNetworkAclEntriesAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EC2CreateRouteAction": {
                return Optional.ofNullable(clazz.cast(this.ec2CreateRouteAction()));
            }
            case "EC2ReplaceRouteAction": {
                return Optional.ofNullable(clazz.cast(this.ec2ReplaceRouteAction()));
            }
            case "EC2DeleteRouteAction": {
                return Optional.ofNullable(clazz.cast(this.ec2DeleteRouteAction()));
            }
            case "EC2CopyRouteTableAction": {
                return Optional.ofNullable(clazz.cast(this.ec2CopyRouteTableAction()));
            }
            case "EC2ReplaceRouteTableAssociationAction": {
                return Optional.ofNullable(clazz.cast(this.ec2ReplaceRouteTableAssociationAction()));
            }
            case "EC2AssociateRouteTableAction": {
                return Optional.ofNullable(clazz.cast(this.ec2AssociateRouteTableAction()));
            }
            case "EC2CreateRouteTableAction": {
                return Optional.ofNullable(clazz.cast(this.ec2CreateRouteTableAction()));
            }
            case "FMSPolicyUpdateFirewallCreationConfigAction": {
                return Optional.ofNullable(clazz.cast(this.fmsPolicyUpdateFirewallCreationConfigAction()));
            }
            case "CreateNetworkAclAction": {
                return Optional.ofNullable(clazz.cast(this.createNetworkAclAction()));
            }
            case "ReplaceNetworkAclAssociationAction": {
                return Optional.ofNullable(clazz.cast(this.replaceNetworkAclAssociationAction()));
            }
            case "CreateNetworkAclEntriesAction": {
                return Optional.ofNullable(clazz.cast(this.createNetworkAclEntriesAction()));
            }
            case "DeleteNetworkAclEntriesAction": {
                return Optional.ofNullable(clazz.cast(this.deleteNetworkAclEntriesAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationAction, T> g) {
        return obj -> g.apply((RemediationAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private EC2CreateRouteAction ec2CreateRouteAction;
        private EC2ReplaceRouteAction ec2ReplaceRouteAction;
        private EC2DeleteRouteAction ec2DeleteRouteAction;
        private EC2CopyRouteTableAction ec2CopyRouteTableAction;
        private EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction;
        private EC2AssociateRouteTableAction ec2AssociateRouteTableAction;
        private EC2CreateRouteTableAction ec2CreateRouteTableAction;
        private FMSPolicyUpdateFirewallCreationConfigAction fmsPolicyUpdateFirewallCreationConfigAction;
        private CreateNetworkAclAction createNetworkAclAction;
        private ReplaceNetworkAclAssociationAction replaceNetworkAclAssociationAction;
        private CreateNetworkAclEntriesAction createNetworkAclEntriesAction;
        private DeleteNetworkAclEntriesAction deleteNetworkAclEntriesAction;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationAction model) {
            this.description(model.description);
            this.ec2CreateRouteAction(model.ec2CreateRouteAction);
            this.ec2ReplaceRouteAction(model.ec2ReplaceRouteAction);
            this.ec2DeleteRouteAction(model.ec2DeleteRouteAction);
            this.ec2CopyRouteTableAction(model.ec2CopyRouteTableAction);
            this.ec2ReplaceRouteTableAssociationAction(model.ec2ReplaceRouteTableAssociationAction);
            this.ec2AssociateRouteTableAction(model.ec2AssociateRouteTableAction);
            this.ec2CreateRouteTableAction(model.ec2CreateRouteTableAction);
            this.fmsPolicyUpdateFirewallCreationConfigAction(model.fmsPolicyUpdateFirewallCreationConfigAction);
            this.createNetworkAclAction(model.createNetworkAclAction);
            this.replaceNetworkAclAssociationAction(model.replaceNetworkAclAssociationAction);
            this.createNetworkAclEntriesAction(model.createNetworkAclEntriesAction);
            this.deleteNetworkAclEntriesAction(model.deleteNetworkAclEntriesAction);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EC2CreateRouteAction.Builder getEc2CreateRouteAction() {
            return this.ec2CreateRouteAction != null ? this.ec2CreateRouteAction.toBuilder() : null;
        }

        public final void setEc2CreateRouteAction(EC2CreateRouteAction.BuilderImpl ec2CreateRouteAction) {
            this.ec2CreateRouteAction = ec2CreateRouteAction != null ? ec2CreateRouteAction.build() : null;
        }

        @Override
        public final Builder ec2CreateRouteAction(EC2CreateRouteAction ec2CreateRouteAction) {
            this.ec2CreateRouteAction = ec2CreateRouteAction;
            return this;
        }

        public final EC2ReplaceRouteAction.Builder getEc2ReplaceRouteAction() {
            return this.ec2ReplaceRouteAction != null ? this.ec2ReplaceRouteAction.toBuilder() : null;
        }

        public final void setEc2ReplaceRouteAction(EC2ReplaceRouteAction.BuilderImpl ec2ReplaceRouteAction) {
            this.ec2ReplaceRouteAction = ec2ReplaceRouteAction != null ? ec2ReplaceRouteAction.build() : null;
        }

        @Override
        public final Builder ec2ReplaceRouteAction(EC2ReplaceRouteAction ec2ReplaceRouteAction) {
            this.ec2ReplaceRouteAction = ec2ReplaceRouteAction;
            return this;
        }

        public final EC2DeleteRouteAction.Builder getEc2DeleteRouteAction() {
            return this.ec2DeleteRouteAction != null ? this.ec2DeleteRouteAction.toBuilder() : null;
        }

        public final void setEc2DeleteRouteAction(EC2DeleteRouteAction.BuilderImpl ec2DeleteRouteAction) {
            this.ec2DeleteRouteAction = ec2DeleteRouteAction != null ? ec2DeleteRouteAction.build() : null;
        }

        @Override
        public final Builder ec2DeleteRouteAction(EC2DeleteRouteAction ec2DeleteRouteAction) {
            this.ec2DeleteRouteAction = ec2DeleteRouteAction;
            return this;
        }

        public final EC2CopyRouteTableAction.Builder getEc2CopyRouteTableAction() {
            return this.ec2CopyRouteTableAction != null ? this.ec2CopyRouteTableAction.toBuilder() : null;
        }

        public final void setEc2CopyRouteTableAction(EC2CopyRouteTableAction.BuilderImpl ec2CopyRouteTableAction) {
            this.ec2CopyRouteTableAction = ec2CopyRouteTableAction != null ? ec2CopyRouteTableAction.build() : null;
        }

        @Override
        public final Builder ec2CopyRouteTableAction(EC2CopyRouteTableAction ec2CopyRouteTableAction) {
            this.ec2CopyRouteTableAction = ec2CopyRouteTableAction;
            return this;
        }

        public final EC2ReplaceRouteTableAssociationAction.Builder getEc2ReplaceRouteTableAssociationAction() {
            return this.ec2ReplaceRouteTableAssociationAction != null ? this.ec2ReplaceRouteTableAssociationAction.toBuilder() : null;
        }

        public final void setEc2ReplaceRouteTableAssociationAction(EC2ReplaceRouteTableAssociationAction.BuilderImpl ec2ReplaceRouteTableAssociationAction) {
            this.ec2ReplaceRouteTableAssociationAction = ec2ReplaceRouteTableAssociationAction != null ? ec2ReplaceRouteTableAssociationAction.build() : null;
        }

        @Override
        public final Builder ec2ReplaceRouteTableAssociationAction(EC2ReplaceRouteTableAssociationAction ec2ReplaceRouteTableAssociationAction) {
            this.ec2ReplaceRouteTableAssociationAction = ec2ReplaceRouteTableAssociationAction;
            return this;
        }

        public final EC2AssociateRouteTableAction.Builder getEc2AssociateRouteTableAction() {
            return this.ec2AssociateRouteTableAction != null ? this.ec2AssociateRouteTableAction.toBuilder() : null;
        }

        public final void setEc2AssociateRouteTableAction(EC2AssociateRouteTableAction.BuilderImpl ec2AssociateRouteTableAction) {
            this.ec2AssociateRouteTableAction = ec2AssociateRouteTableAction != null ? ec2AssociateRouteTableAction.build() : null;
        }

        @Override
        public final Builder ec2AssociateRouteTableAction(EC2AssociateRouteTableAction ec2AssociateRouteTableAction) {
            this.ec2AssociateRouteTableAction = ec2AssociateRouteTableAction;
            return this;
        }

        public final EC2CreateRouteTableAction.Builder getEc2CreateRouteTableAction() {
            return this.ec2CreateRouteTableAction != null ? this.ec2CreateRouteTableAction.toBuilder() : null;
        }

        public final void setEc2CreateRouteTableAction(EC2CreateRouteTableAction.BuilderImpl ec2CreateRouteTableAction) {
            this.ec2CreateRouteTableAction = ec2CreateRouteTableAction != null ? ec2CreateRouteTableAction.build() : null;
        }

        @Override
        public final Builder ec2CreateRouteTableAction(EC2CreateRouteTableAction ec2CreateRouteTableAction) {
            this.ec2CreateRouteTableAction = ec2CreateRouteTableAction;
            return this;
        }

        public final FMSPolicyUpdateFirewallCreationConfigAction.Builder getFmsPolicyUpdateFirewallCreationConfigAction() {
            return this.fmsPolicyUpdateFirewallCreationConfigAction != null ? this.fmsPolicyUpdateFirewallCreationConfigAction.toBuilder() : null;
        }

        public final void setFmsPolicyUpdateFirewallCreationConfigAction(FMSPolicyUpdateFirewallCreationConfigAction.BuilderImpl fmsPolicyUpdateFirewallCreationConfigAction) {
            this.fmsPolicyUpdateFirewallCreationConfigAction = fmsPolicyUpdateFirewallCreationConfigAction != null ? fmsPolicyUpdateFirewallCreationConfigAction.build() : null;
        }

        @Override
        public final Builder fmsPolicyUpdateFirewallCreationConfigAction(FMSPolicyUpdateFirewallCreationConfigAction fmsPolicyUpdateFirewallCreationConfigAction) {
            this.fmsPolicyUpdateFirewallCreationConfigAction = fmsPolicyUpdateFirewallCreationConfigAction;
            return this;
        }

        public final CreateNetworkAclAction.Builder getCreateNetworkAclAction() {
            return this.createNetworkAclAction != null ? this.createNetworkAclAction.toBuilder() : null;
        }

        public final void setCreateNetworkAclAction(CreateNetworkAclAction.BuilderImpl createNetworkAclAction) {
            this.createNetworkAclAction = createNetworkAclAction != null ? createNetworkAclAction.build() : null;
        }

        @Override
        public final Builder createNetworkAclAction(CreateNetworkAclAction createNetworkAclAction) {
            this.createNetworkAclAction = createNetworkAclAction;
            return this;
        }

        public final ReplaceNetworkAclAssociationAction.Builder getReplaceNetworkAclAssociationAction() {
            return this.replaceNetworkAclAssociationAction != null ? this.replaceNetworkAclAssociationAction.toBuilder() : null;
        }

        public final void setReplaceNetworkAclAssociationAction(ReplaceNetworkAclAssociationAction.BuilderImpl replaceNetworkAclAssociationAction) {
            this.replaceNetworkAclAssociationAction = replaceNetworkAclAssociationAction != null ? replaceNetworkAclAssociationAction.build() : null;
        }

        @Override
        public final Builder replaceNetworkAclAssociationAction(ReplaceNetworkAclAssociationAction replaceNetworkAclAssociationAction) {
            this.replaceNetworkAclAssociationAction = replaceNetworkAclAssociationAction;
            return this;
        }

        public final CreateNetworkAclEntriesAction.Builder getCreateNetworkAclEntriesAction() {
            return this.createNetworkAclEntriesAction != null ? this.createNetworkAclEntriesAction.toBuilder() : null;
        }

        public final void setCreateNetworkAclEntriesAction(CreateNetworkAclEntriesAction.BuilderImpl createNetworkAclEntriesAction) {
            this.createNetworkAclEntriesAction = createNetworkAclEntriesAction != null ? createNetworkAclEntriesAction.build() : null;
        }

        @Override
        public final Builder createNetworkAclEntriesAction(CreateNetworkAclEntriesAction createNetworkAclEntriesAction) {
            this.createNetworkAclEntriesAction = createNetworkAclEntriesAction;
            return this;
        }

        public final DeleteNetworkAclEntriesAction.Builder getDeleteNetworkAclEntriesAction() {
            return this.deleteNetworkAclEntriesAction != null ? this.deleteNetworkAclEntriesAction.toBuilder() : null;
        }

        public final void setDeleteNetworkAclEntriesAction(DeleteNetworkAclEntriesAction.BuilderImpl deleteNetworkAclEntriesAction) {
            this.deleteNetworkAclEntriesAction = deleteNetworkAclEntriesAction != null ? deleteNetworkAclEntriesAction.build() : null;
        }

        @Override
        public final Builder deleteNetworkAclEntriesAction(DeleteNetworkAclEntriesAction deleteNetworkAclEntriesAction) {
            this.deleteNetworkAclEntriesAction = deleteNetworkAclEntriesAction;
            return this;
        }

        public RemediationAction build() {
            return new RemediationAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemediationAction> {
        public Builder description(String var1);

        public Builder ec2CreateRouteAction(EC2CreateRouteAction var1);

        default public Builder ec2CreateRouteAction(Consumer<EC2CreateRouteAction.Builder> ec2CreateRouteAction) {
            return this.ec2CreateRouteAction((EC2CreateRouteAction)((EC2CreateRouteAction.Builder)EC2CreateRouteAction.builder().applyMutation(ec2CreateRouteAction)).build());
        }

        public Builder ec2ReplaceRouteAction(EC2ReplaceRouteAction var1);

        default public Builder ec2ReplaceRouteAction(Consumer<EC2ReplaceRouteAction.Builder> ec2ReplaceRouteAction) {
            return this.ec2ReplaceRouteAction((EC2ReplaceRouteAction)((EC2ReplaceRouteAction.Builder)EC2ReplaceRouteAction.builder().applyMutation(ec2ReplaceRouteAction)).build());
        }

        public Builder ec2DeleteRouteAction(EC2DeleteRouteAction var1);

        default public Builder ec2DeleteRouteAction(Consumer<EC2DeleteRouteAction.Builder> ec2DeleteRouteAction) {
            return this.ec2DeleteRouteAction((EC2DeleteRouteAction)((EC2DeleteRouteAction.Builder)EC2DeleteRouteAction.builder().applyMutation(ec2DeleteRouteAction)).build());
        }

        public Builder ec2CopyRouteTableAction(EC2CopyRouteTableAction var1);

        default public Builder ec2CopyRouteTableAction(Consumer<EC2CopyRouteTableAction.Builder> ec2CopyRouteTableAction) {
            return this.ec2CopyRouteTableAction((EC2CopyRouteTableAction)((EC2CopyRouteTableAction.Builder)EC2CopyRouteTableAction.builder().applyMutation(ec2CopyRouteTableAction)).build());
        }

        public Builder ec2ReplaceRouteTableAssociationAction(EC2ReplaceRouteTableAssociationAction var1);

        default public Builder ec2ReplaceRouteTableAssociationAction(Consumer<EC2ReplaceRouteTableAssociationAction.Builder> ec2ReplaceRouteTableAssociationAction) {
            return this.ec2ReplaceRouteTableAssociationAction((EC2ReplaceRouteTableAssociationAction)((EC2ReplaceRouteTableAssociationAction.Builder)EC2ReplaceRouteTableAssociationAction.builder().applyMutation(ec2ReplaceRouteTableAssociationAction)).build());
        }

        public Builder ec2AssociateRouteTableAction(EC2AssociateRouteTableAction var1);

        default public Builder ec2AssociateRouteTableAction(Consumer<EC2AssociateRouteTableAction.Builder> ec2AssociateRouteTableAction) {
            return this.ec2AssociateRouteTableAction((EC2AssociateRouteTableAction)((EC2AssociateRouteTableAction.Builder)EC2AssociateRouteTableAction.builder().applyMutation(ec2AssociateRouteTableAction)).build());
        }

        public Builder ec2CreateRouteTableAction(EC2CreateRouteTableAction var1);

        default public Builder ec2CreateRouteTableAction(Consumer<EC2CreateRouteTableAction.Builder> ec2CreateRouteTableAction) {
            return this.ec2CreateRouteTableAction((EC2CreateRouteTableAction)((EC2CreateRouteTableAction.Builder)EC2CreateRouteTableAction.builder().applyMutation(ec2CreateRouteTableAction)).build());
        }

        public Builder fmsPolicyUpdateFirewallCreationConfigAction(FMSPolicyUpdateFirewallCreationConfigAction var1);

        default public Builder fmsPolicyUpdateFirewallCreationConfigAction(Consumer<FMSPolicyUpdateFirewallCreationConfigAction.Builder> fmsPolicyUpdateFirewallCreationConfigAction) {
            return this.fmsPolicyUpdateFirewallCreationConfigAction((FMSPolicyUpdateFirewallCreationConfigAction)((FMSPolicyUpdateFirewallCreationConfigAction.Builder)FMSPolicyUpdateFirewallCreationConfigAction.builder().applyMutation(fmsPolicyUpdateFirewallCreationConfigAction)).build());
        }

        public Builder createNetworkAclAction(CreateNetworkAclAction var1);

        default public Builder createNetworkAclAction(Consumer<CreateNetworkAclAction.Builder> createNetworkAclAction) {
            return this.createNetworkAclAction((CreateNetworkAclAction)((CreateNetworkAclAction.Builder)CreateNetworkAclAction.builder().applyMutation(createNetworkAclAction)).build());
        }

        public Builder replaceNetworkAclAssociationAction(ReplaceNetworkAclAssociationAction var1);

        default public Builder replaceNetworkAclAssociationAction(Consumer<ReplaceNetworkAclAssociationAction.Builder> replaceNetworkAclAssociationAction) {
            return this.replaceNetworkAclAssociationAction((ReplaceNetworkAclAssociationAction)((ReplaceNetworkAclAssociationAction.Builder)ReplaceNetworkAclAssociationAction.builder().applyMutation(replaceNetworkAclAssociationAction)).build());
        }

        public Builder createNetworkAclEntriesAction(CreateNetworkAclEntriesAction var1);

        default public Builder createNetworkAclEntriesAction(Consumer<CreateNetworkAclEntriesAction.Builder> createNetworkAclEntriesAction) {
            return this.createNetworkAclEntriesAction((CreateNetworkAclEntriesAction)((CreateNetworkAclEntriesAction.Builder)CreateNetworkAclEntriesAction.builder().applyMutation(createNetworkAclEntriesAction)).build());
        }

        public Builder deleteNetworkAclEntriesAction(DeleteNetworkAclEntriesAction var1);

        default public Builder deleteNetworkAclEntriesAction(Consumer<DeleteNetworkAclEntriesAction.Builder> deleteNetworkAclEntriesAction) {
            return this.deleteNetworkAclEntriesAction((DeleteNetworkAclEntriesAction)((DeleteNetworkAclEntriesAction.Builder)DeleteNetworkAclEntriesAction.builder().applyMutation(deleteNetworkAclEntriesAction)).build());
        }
    }
}

