/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.ActionTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2AssociateRouteTableAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2AssociateRouteTableAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EC2AssociateRouteTableAction.getter(EC2AssociateRouteTableAction::description)).setter(EC2AssociateRouteTableAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ActionTarget> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteTableId").getter(EC2AssociateRouteTableAction.getter(EC2AssociateRouteTableAction::routeTableId)).setter(EC2AssociateRouteTableAction.setter(Builder::routeTableId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final SdkField<ActionTarget> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubnetId").getter(EC2AssociateRouteTableAction.getter(EC2AssociateRouteTableAction::subnetId)).setter(EC2AssociateRouteTableAction.setter(Builder::subnetId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<ActionTarget> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GatewayId").getter(EC2AssociateRouteTableAction.getter(EC2AssociateRouteTableAction::gatewayId)).setter(EC2AssociateRouteTableAction.setter(Builder::gatewayId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ROUTE_TABLE_ID_FIELD, SUBNET_ID_FIELD, GATEWAY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EC2AssociateRouteTableAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final ActionTarget routeTableId;
    private final ActionTarget subnetId;
    private final ActionTarget gatewayId;

    private EC2AssociateRouteTableAction(BuilderImpl builder) {
        this.description = builder.description;
        this.routeTableId = builder.routeTableId;
        this.subnetId = builder.subnetId;
        this.gatewayId = builder.gatewayId;
    }

    public final String description() {
        return this.description;
    }

    public final ActionTarget routeTableId() {
        return this.routeTableId;
    }

    public final ActionTarget subnetId() {
        return this.subnetId;
    }

    public final ActionTarget gatewayId() {
        return this.gatewayId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2AssociateRouteTableAction)) {
            return false;
        }
        EC2AssociateRouteTableAction other = (EC2AssociateRouteTableAction)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.gatewayId(), other.gatewayId());
    }

    public final String toString() {
        return ToString.builder((String)"EC2AssociateRouteTableAction").add("Description", (Object)this.description()).add("RouteTableId", (Object)this.routeTableId()).add("SubnetId", (Object)this.subnetId()).add("GatewayId", (Object)this.gatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("GatewayId", GATEWAY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2AssociateRouteTableAction, T> g) {
        return obj -> g.apply((EC2AssociateRouteTableAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private ActionTarget routeTableId;
        private ActionTarget subnetId;
        private ActionTarget gatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2AssociateRouteTableAction model) {
            this.description(model.description);
            this.routeTableId(model.routeTableId);
            this.subnetId(model.subnetId);
            this.gatewayId(model.gatewayId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getRouteTableId() {
            return this.routeTableId != null ? this.routeTableId.toBuilder() : null;
        }

        public final void setRouteTableId(ActionTarget.BuilderImpl routeTableId) {
            this.routeTableId = routeTableId != null ? routeTableId.build() : null;
        }

        @Override
        public final Builder routeTableId(ActionTarget routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final ActionTarget.Builder getSubnetId() {
            return this.subnetId != null ? this.subnetId.toBuilder() : null;
        }

        public final void setSubnetId(ActionTarget.BuilderImpl subnetId) {
            this.subnetId = subnetId != null ? subnetId.build() : null;
        }

        @Override
        public final Builder subnetId(ActionTarget subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final ActionTarget.Builder getGatewayId() {
            return this.gatewayId != null ? this.gatewayId.toBuilder() : null;
        }

        public final void setGatewayId(ActionTarget.BuilderImpl gatewayId) {
            this.gatewayId = gatewayId != null ? gatewayId.build() : null;
        }

        @Override
        public final Builder gatewayId(ActionTarget gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public EC2AssociateRouteTableAction build() {
            return new EC2AssociateRouteTableAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2AssociateRouteTableAction> {
        public Builder description(String var1);

        public Builder routeTableId(ActionTarget var1);

        default public Builder routeTableId(Consumer<ActionTarget.Builder> routeTableId) {
            return this.routeTableId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(routeTableId)).build());
        }

        public Builder subnetId(ActionTarget var1);

        default public Builder subnetId(Consumer<ActionTarget.Builder> subnetId) {
            return this.subnetId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(subnetId)).build());
        }

        public Builder gatewayId(ActionTarget var1);

        default public Builder gatewayId(Consumer<ActionTarget.Builder> gatewayId) {
            return this.gatewayId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(gatewayId)).build());
        }
    }
}

