/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.ResourceSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutResourceSetResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, PutResourceSetResponse> {
    private static final SdkField<ResourceSet> RESOURCE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceSet").getter(PutResourceSetResponse.getter(PutResourceSetResponse::resourceSet)).setter(PutResourceSetResponse.setter(Builder::resourceSet)).constructor(ResourceSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSet").build()}).build();
    private static final SdkField<String> RESOURCE_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetArn").getter(PutResourceSetResponse.getter(PutResourceSetResponse::resourceSetArn)).setter(PutResourceSetResponse.setter(Builder::resourceSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_FIELD, RESOURCE_SET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceSet", RESOURCE_SET_FIELD);
            this.put("ResourceSetArn", RESOURCE_SET_ARN_FIELD);
        }
    });
    private final ResourceSet resourceSet;
    private final String resourceSetArn;

    private PutResourceSetResponse(BuilderImpl builder) {
        super(builder);
        this.resourceSet = builder.resourceSet;
        this.resourceSetArn = builder.resourceSetArn;
    }

    public final ResourceSet resourceSet() {
        return this.resourceSet;
    }

    public final String resourceSetArn() {
        return this.resourceSetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourceSetResponse)) {
            return false;
        }
        PutResourceSetResponse other = (PutResourceSetResponse)((Object)obj);
        return Objects.equals(this.resourceSet(), other.resourceSet()) && Objects.equals(this.resourceSetArn(), other.resourceSetArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutResourceSetResponse").add("ResourceSet", (Object)this.resourceSet()).add("ResourceSetArn", (Object)this.resourceSetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceSet": {
                return Optional.ofNullable(clazz.cast(this.resourceSet()));
            }
            case "ResourceSetArn": {
                return Optional.ofNullable(clazz.cast(this.resourceSetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutResourceSetResponse, T> g) {
        return obj -> g.apply((PutResourceSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private ResourceSet resourceSet;
        private String resourceSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourceSetResponse model) {
            super(model);
            this.resourceSet(model.resourceSet);
            this.resourceSetArn(model.resourceSetArn);
        }

        public final ResourceSet.Builder getResourceSet() {
            return this.resourceSet != null ? this.resourceSet.toBuilder() : null;
        }

        public final void setResourceSet(ResourceSet.BuilderImpl resourceSet) {
            this.resourceSet = resourceSet != null ? resourceSet.build() : null;
        }

        @Override
        public final Builder resourceSet(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
            return this;
        }

        public final String getResourceSetArn() {
            return this.resourceSetArn;
        }

        public final void setResourceSetArn(String resourceSetArn) {
            this.resourceSetArn = resourceSetArn;
        }

        @Override
        public final Builder resourceSetArn(String resourceSetArn) {
            this.resourceSetArn = resourceSetArn;
            return this;
        }

        @Override
        public PutResourceSetResponse build() {
            return new PutResourceSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutResourceSetResponse> {
        public Builder resourceSet(ResourceSet var1);

        default public Builder resourceSet(Consumer<ResourceSet.Builder> resourceSet) {
            return this.resourceSet((ResourceSet)((ResourceSet.Builder)ResourceSet.builder().applyMutation(resourceSet)).build());
        }

        public Builder resourceSetArn(String var1);
    }
}

