/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.EntryViolation;
import software.amazon.awssdk.services.fms.model.EntryViolationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidNetworkAclEntriesViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvalidNetworkAclEntriesViolation> {
    private static final SdkField<String> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Vpc").getter(InvalidNetworkAclEntriesViolation.getter(InvalidNetworkAclEntriesViolation::vpc)).setter(InvalidNetworkAclEntriesViolation.setter(Builder::vpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()}).build();
    private static final SdkField<String> SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subnet").getter(InvalidNetworkAclEntriesViolation.getter(InvalidNetworkAclEntriesViolation::subnet)).setter(InvalidNetworkAclEntriesViolation.setter(Builder::subnet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").build()}).build();
    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetAvailabilityZone").getter(InvalidNetworkAclEntriesViolation.getter(InvalidNetworkAclEntriesViolation::subnetAvailabilityZone)).setter(InvalidNetworkAclEntriesViolation.setter(Builder::subnetAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build()}).build();
    private static final SdkField<String> CURRENT_ASSOCIATED_NETWORK_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentAssociatedNetworkAcl").getter(InvalidNetworkAclEntriesViolation.getter(InvalidNetworkAclEntriesViolation::currentAssociatedNetworkAcl)).setter(InvalidNetworkAclEntriesViolation.setter(Builder::currentAssociatedNetworkAcl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAssociatedNetworkAcl").build()}).build();
    private static final SdkField<List<EntryViolation>> ENTRY_VIOLATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntryViolations").getter(InvalidNetworkAclEntriesViolation.getter(InvalidNetworkAclEntriesViolation::entryViolations)).setter(InvalidNetworkAclEntriesViolation.setter(Builder::entryViolations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryViolations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntryViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_FIELD, SUBNET_FIELD, SUBNET_AVAILABILITY_ZONE_FIELD, CURRENT_ASSOCIATED_NETWORK_ACL_FIELD, ENTRY_VIOLATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Vpc", VPC_FIELD);
            this.put("Subnet", SUBNET_FIELD);
            this.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
            this.put("CurrentAssociatedNetworkAcl", CURRENT_ASSOCIATED_NETWORK_ACL_FIELD);
            this.put("EntryViolations", ENTRY_VIOLATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String vpc;
    private final String subnet;
    private final String subnetAvailabilityZone;
    private final String currentAssociatedNetworkAcl;
    private final List<EntryViolation> entryViolations;

    private InvalidNetworkAclEntriesViolation(BuilderImpl builder) {
        this.vpc = builder.vpc;
        this.subnet = builder.subnet;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.currentAssociatedNetworkAcl = builder.currentAssociatedNetworkAcl;
        this.entryViolations = builder.entryViolations;
    }

    public final String vpc() {
        return this.vpc;
    }

    public final String subnet() {
        return this.subnet;
    }

    public final String subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public final String currentAssociatedNetworkAcl() {
        return this.currentAssociatedNetworkAcl;
    }

    public final boolean hasEntryViolations() {
        return this.entryViolations != null && !(this.entryViolations instanceof SdkAutoConstructList);
    }

    public final List<EntryViolation> entryViolations() {
        return this.entryViolations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAssociatedNetworkAcl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntryViolations() ? this.entryViolations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidNetworkAclEntriesViolation)) {
            return false;
        }
        InvalidNetworkAclEntriesViolation other = (InvalidNetworkAclEntriesViolation)obj;
        return Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.subnet(), other.subnet()) && Objects.equals(this.subnetAvailabilityZone(), other.subnetAvailabilityZone()) && Objects.equals(this.currentAssociatedNetworkAcl(), other.currentAssociatedNetworkAcl()) && this.hasEntryViolations() == other.hasEntryViolations() && Objects.equals(this.entryViolations(), other.entryViolations());
    }

    public final String toString() {
        return ToString.builder((String)"InvalidNetworkAclEntriesViolation").add("Vpc", (Object)this.vpc()).add("Subnet", (Object)this.subnet()).add("SubnetAvailabilityZone", (Object)this.subnetAvailabilityZone()).add("CurrentAssociatedNetworkAcl", (Object)this.currentAssociatedNetworkAcl()).add("EntryViolations", this.hasEntryViolations() ? this.entryViolations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "Subnet": {
                return Optional.ofNullable(clazz.cast(this.subnet()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.subnetAvailabilityZone()));
            }
            case "CurrentAssociatedNetworkAcl": {
                return Optional.ofNullable(clazz.cast(this.currentAssociatedNetworkAcl()));
            }
            case "EntryViolations": {
                return Optional.ofNullable(clazz.cast(this.entryViolations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvalidNetworkAclEntriesViolation, T> g) {
        return obj -> g.apply((InvalidNetworkAclEntriesViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpc;
        private String subnet;
        private String subnetAvailabilityZone;
        private String currentAssociatedNetworkAcl;
        private List<EntryViolation> entryViolations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidNetworkAclEntriesViolation model) {
            this.vpc(model.vpc);
            this.subnet(model.subnet);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
            this.currentAssociatedNetworkAcl(model.currentAssociatedNetworkAcl);
            this.entryViolations(model.entryViolations);
        }

        public final String getVpc() {
            return this.vpc;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getSubnet() {
            return this.subnet;
        }

        public final void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        @Override
        public final Builder subnet(String subnet) {
            this.subnet = subnet;
            return this;
        }

        public final String getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone;
        }

        public final void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getCurrentAssociatedNetworkAcl() {
            return this.currentAssociatedNetworkAcl;
        }

        public final void setCurrentAssociatedNetworkAcl(String currentAssociatedNetworkAcl) {
            this.currentAssociatedNetworkAcl = currentAssociatedNetworkAcl;
        }

        @Override
        public final Builder currentAssociatedNetworkAcl(String currentAssociatedNetworkAcl) {
            this.currentAssociatedNetworkAcl = currentAssociatedNetworkAcl;
            return this;
        }

        public final List<EntryViolation.Builder> getEntryViolations() {
            List<EntryViolation.Builder> result = EntryViolationsCopier.copyToBuilder(this.entryViolations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntryViolations(Collection<EntryViolation.BuilderImpl> entryViolations) {
            this.entryViolations = EntryViolationsCopier.copyFromBuilder(entryViolations);
        }

        @Override
        public final Builder entryViolations(Collection<EntryViolation> entryViolations) {
            this.entryViolations = EntryViolationsCopier.copy(entryViolations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryViolations(EntryViolation ... entryViolations) {
            this.entryViolations(Arrays.asList(entryViolations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryViolations(Consumer<EntryViolation.Builder> ... entryViolations) {
            this.entryViolations(Stream.of(entryViolations).map(c -> (EntryViolation)((EntryViolation.Builder)EntryViolation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InvalidNetworkAclEntriesViolation build() {
            return new InvalidNetworkAclEntriesViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidNetworkAclEntriesViolation> {
        public Builder vpc(String var1);

        public Builder subnet(String var1);

        public Builder subnetAvailabilityZone(String var1);

        public Builder currentAssociatedNetworkAcl(String var1);

        public Builder entryViolations(Collection<EntryViolation> var1);

        public Builder entryViolations(EntryViolation ... var1);

        public Builder entryViolations(Consumer<EntryViolation.Builder> ... var1);
    }
}

