/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.LengthBoundedStringListCopier;
import software.amazon.awssdk.services.fms.model.ResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpectedRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpectedRoute> {
    private static final SdkField<String> IP_V4_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpV4Cidr").getter(ExpectedRoute.getter(ExpectedRoute::ipV4Cidr)).setter(ExpectedRoute.setter(Builder::ipV4Cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV4Cidr").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(ExpectedRoute.getter(ExpectedRoute::prefixListId)).setter(ExpectedRoute.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").build()}).build();
    private static final SdkField<String> IP_V6_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpV6Cidr").getter(ExpectedRoute.getter(ExpectedRoute::ipV6Cidr)).setter(ExpectedRoute.setter(Builder::ipV6Cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV6Cidr").build()}).build();
    private static final SdkField<List<String>> CONTRIBUTING_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContributingSubnets").getter(ExpectedRoute.getter(ExpectedRoute::contributingSubnets)).setter(ExpectedRoute.setter(Builder::contributingSubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributingSubnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedTargets").getter(ExpectedRoute.getter(ExpectedRoute::allowedTargets)).setter(ExpectedRoute.setter(Builder::allowedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(ExpectedRoute.getter(ExpectedRoute::routeTableId)).setter(ExpectedRoute.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_V4_CIDR_FIELD, PREFIX_LIST_ID_FIELD, IP_V6_CIDR_FIELD, CONTRIBUTING_SUBNETS_FIELD, ALLOWED_TARGETS_FIELD, ROUTE_TABLE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IpV4Cidr", IP_V4_CIDR_FIELD);
            this.put("PrefixListId", PREFIX_LIST_ID_FIELD);
            this.put("IpV6Cidr", IP_V6_CIDR_FIELD);
            this.put("ContributingSubnets", CONTRIBUTING_SUBNETS_FIELD);
            this.put("AllowedTargets", ALLOWED_TARGETS_FIELD);
            this.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ipV4Cidr;
    private final String prefixListId;
    private final String ipV6Cidr;
    private final List<String> contributingSubnets;
    private final List<String> allowedTargets;
    private final String routeTableId;

    private ExpectedRoute(BuilderImpl builder) {
        this.ipV4Cidr = builder.ipV4Cidr;
        this.prefixListId = builder.prefixListId;
        this.ipV6Cidr = builder.ipV6Cidr;
        this.contributingSubnets = builder.contributingSubnets;
        this.allowedTargets = builder.allowedTargets;
        this.routeTableId = builder.routeTableId;
    }

    public final String ipV4Cidr() {
        return this.ipV4Cidr;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String ipV6Cidr() {
        return this.ipV6Cidr;
    }

    public final boolean hasContributingSubnets() {
        return this.contributingSubnets != null && !(this.contributingSubnets instanceof SdkAutoConstructList);
    }

    public final List<String> contributingSubnets() {
        return this.contributingSubnets;
    }

    public final boolean hasAllowedTargets() {
        return this.allowedTargets != null && !(this.allowedTargets instanceof SdkAutoConstructList);
    }

    public final List<String> allowedTargets() {
        return this.allowedTargets;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipV4Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipV6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributingSubnets() ? this.contributingSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedTargets() ? this.allowedTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpectedRoute)) {
            return false;
        }
        ExpectedRoute other = (ExpectedRoute)obj;
        return Objects.equals(this.ipV4Cidr(), other.ipV4Cidr()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.ipV6Cidr(), other.ipV6Cidr()) && this.hasContributingSubnets() == other.hasContributingSubnets() && Objects.equals(this.contributingSubnets(), other.contributingSubnets()) && this.hasAllowedTargets() == other.hasAllowedTargets() && Objects.equals(this.allowedTargets(), other.allowedTargets()) && Objects.equals(this.routeTableId(), other.routeTableId());
    }

    public final String toString() {
        return ToString.builder((String)"ExpectedRoute").add("IpV4Cidr", (Object)this.ipV4Cidr()).add("PrefixListId", (Object)this.prefixListId()).add("IpV6Cidr", (Object)this.ipV6Cidr()).add("ContributingSubnets", this.hasContributingSubnets() ? this.contributingSubnets() : null).add("AllowedTargets", this.hasAllowedTargets() ? this.allowedTargets() : null).add("RouteTableId", (Object)this.routeTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpV4Cidr": {
                return Optional.ofNullable(clazz.cast(this.ipV4Cidr()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "IpV6Cidr": {
                return Optional.ofNullable(clazz.cast(this.ipV6Cidr()));
            }
            case "ContributingSubnets": {
                return Optional.ofNullable(clazz.cast(this.contributingSubnets()));
            }
            case "AllowedTargets": {
                return Optional.ofNullable(clazz.cast(this.allowedTargets()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExpectedRoute, T> g) {
        return obj -> g.apply((ExpectedRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipV4Cidr;
        private String prefixListId;
        private String ipV6Cidr;
        private List<String> contributingSubnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedTargets = DefaultSdkAutoConstructList.getInstance();
        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpectedRoute model) {
            this.ipV4Cidr(model.ipV4Cidr);
            this.prefixListId(model.prefixListId);
            this.ipV6Cidr(model.ipV6Cidr);
            this.contributingSubnets(model.contributingSubnets);
            this.allowedTargets(model.allowedTargets);
            this.routeTableId(model.routeTableId);
        }

        public final String getIpV4Cidr() {
            return this.ipV4Cidr;
        }

        public final void setIpV4Cidr(String ipV4Cidr) {
            this.ipV4Cidr = ipV4Cidr;
        }

        @Override
        public final Builder ipV4Cidr(String ipV4Cidr) {
            this.ipV4Cidr = ipV4Cidr;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getIpV6Cidr() {
            return this.ipV6Cidr;
        }

        public final void setIpV6Cidr(String ipV6Cidr) {
            this.ipV6Cidr = ipV6Cidr;
        }

        @Override
        public final Builder ipV6Cidr(String ipV6Cidr) {
            this.ipV6Cidr = ipV6Cidr;
            return this;
        }

        public final Collection<String> getContributingSubnets() {
            if (this.contributingSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contributingSubnets;
        }

        public final void setContributingSubnets(Collection<String> contributingSubnets) {
            this.contributingSubnets = ResourceIdListCopier.copy(contributingSubnets);
        }

        @Override
        public final Builder contributingSubnets(Collection<String> contributingSubnets) {
            this.contributingSubnets = ResourceIdListCopier.copy(contributingSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributingSubnets(String ... contributingSubnets) {
            this.contributingSubnets(Arrays.asList(contributingSubnets));
            return this;
        }

        public final Collection<String> getAllowedTargets() {
            if (this.allowedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedTargets;
        }

        public final void setAllowedTargets(Collection<String> allowedTargets) {
            this.allowedTargets = LengthBoundedStringListCopier.copy(allowedTargets);
        }

        @Override
        public final Builder allowedTargets(Collection<String> allowedTargets) {
            this.allowedTargets = LengthBoundedStringListCopier.copy(allowedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedTargets(String ... allowedTargets) {
            this.allowedTargets(Arrays.asList(allowedTargets));
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public ExpectedRoute build() {
            return new ExpectedRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpectedRoute> {
        public Builder ipV4Cidr(String var1);

        public Builder prefixListId(String var1);

        public Builder ipV6Cidr(String var1);

        public Builder contributingSubnets(Collection<String> var1);

        public Builder contributingSubnets(String ... var1);

        public Builder allowedTargets(Collection<String> var1);

        public Builder allowedTargets(String ... var1);

        public Builder routeTableId(String var1);
    }
}

