/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AppsListData;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAppsListResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, PutAppsListResponse> {
    private static final SdkField<AppsListData> APPS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppsList").getter(PutAppsListResponse.getter(PutAppsListResponse::appsList)).setter(PutAppsListResponse.setter(Builder::appsList)).constructor(AppsListData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsList").build()}).build();
    private static final SdkField<String> APPS_LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppsListArn").getter(PutAppsListResponse.getter(PutAppsListResponse::appsListArn)).setter(PutAppsListResponse.setter(Builder::appsListArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsListArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_LIST_FIELD, APPS_LIST_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AppsList", APPS_LIST_FIELD);
            this.put("AppsListArn", APPS_LIST_ARN_FIELD);
        }
    });
    private final AppsListData appsList;
    private final String appsListArn;

    private PutAppsListResponse(BuilderImpl builder) {
        super(builder);
        this.appsList = builder.appsList;
        this.appsListArn = builder.appsListArn;
    }

    public final AppsListData appsList() {
        return this.appsList;
    }

    public final String appsListArn() {
        return this.appsListArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.appsListArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppsListResponse)) {
            return false;
        }
        PutAppsListResponse other = (PutAppsListResponse)((Object)obj);
        return Objects.equals(this.appsList(), other.appsList()) && Objects.equals(this.appsListArn(), other.appsListArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutAppsListResponse").add("AppsList", (Object)this.appsList()).add("AppsListArn", (Object)this.appsListArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppsList": {
                return Optional.ofNullable(clazz.cast(this.appsList()));
            }
            case "AppsListArn": {
                return Optional.ofNullable(clazz.cast(this.appsListArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutAppsListResponse, T> g) {
        return obj -> g.apply((PutAppsListResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private AppsListData appsList;
        private String appsListArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppsListResponse model) {
            super(model);
            this.appsList(model.appsList);
            this.appsListArn(model.appsListArn);
        }

        public final AppsListData.Builder getAppsList() {
            return this.appsList != null ? this.appsList.toBuilder() : null;
        }

        public final void setAppsList(AppsListData.BuilderImpl appsList) {
            this.appsList = appsList != null ? appsList.build() : null;
        }

        @Override
        public final Builder appsList(AppsListData appsList) {
            this.appsList = appsList;
            return this;
        }

        public final String getAppsListArn() {
            return this.appsListArn;
        }

        public final void setAppsListArn(String appsListArn) {
            this.appsListArn = appsListArn;
        }

        @Override
        public final Builder appsListArn(String appsListArn) {
            this.appsListArn = appsListArn;
            return this;
        }

        @Override
        public PutAppsListResponse build() {
            return new PutAppsListResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAppsListResponse> {
        public Builder appsList(AppsListData var1);

        default public Builder appsList(Consumer<AppsListData.Builder> appsList) {
            return this.appsList((AppsListData)((AppsListData.Builder)AppsListData.builder().applyMutation(appsList)).build());
        }

        public Builder appsListArn(String var1);
    }
}

