/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.AWSRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegionScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegionScope> {
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(RegionScope.getter(RegionScope::regions)).setter(RegionScope.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_REGIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllRegionsEnabled").getter(RegionScope.getter(RegionScope::allRegionsEnabled)).setter(RegionScope.setter(Builder::allRegionsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllRegionsEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONS_FIELD, ALL_REGIONS_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Regions", REGIONS_FIELD);
            this.put("AllRegionsEnabled", ALL_REGIONS_ENABLED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> regions;
    private final Boolean allRegionsEnabled;

    private RegionScope(BuilderImpl builder) {
        this.regions = builder.regions;
        this.allRegionsEnabled = builder.allRegionsEnabled;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final Boolean allRegionsEnabled() {
        return this.allRegionsEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allRegionsEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionScope)) {
            return false;
        }
        RegionScope other = (RegionScope)obj;
        return this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.allRegionsEnabled(), other.allRegionsEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"RegionScope").add("Regions", this.hasRegions() ? this.regions() : null).add("AllRegionsEnabled", (Object)this.allRegionsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "AllRegionsEnabled": {
                return Optional.ofNullable(clazz.cast(this.allRegionsEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegionScope, T> g) {
        return obj -> g.apply((RegionScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private Boolean allRegionsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionScope model) {
            this.regions(model.regions);
            this.allRegionsEnabled(model.allRegionsEnabled);
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = AWSRegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = AWSRegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final Boolean getAllRegionsEnabled() {
            return this.allRegionsEnabled;
        }

        public final void setAllRegionsEnabled(Boolean allRegionsEnabled) {
            this.allRegionsEnabled = allRegionsEnabled;
        }

        @Override
        public final Builder allRegionsEnabled(Boolean allRegionsEnabled) {
            this.allRegionsEnabled = allRegionsEnabled;
            return this;
        }

        public RegionScope build() {
            return new RegionScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegionScope> {
        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder allRegionsEnabled(Boolean var1);
    }
}

