/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsAsyncClient;
import software.amazon.awssdk.services.fms.internal.UserAgentUtils;
import software.amazon.awssdk.services.fms.model.AdminAccountSummary;
import software.amazon.awssdk.services.fms.model.ListAdminAccountsForOrganizationRequest;
import software.amazon.awssdk.services.fms.model.ListAdminAccountsForOrganizationResponse;

public class ListAdminAccountsForOrganizationPublisher
implements SdkPublisher<ListAdminAccountsForOrganizationResponse> {
    private final FmsAsyncClient client;
    private final ListAdminAccountsForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAdminAccountsForOrganizationPublisher(FmsAsyncClient client, ListAdminAccountsForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAdminAccountsForOrganizationPublisher(FmsAsyncClient client, ListAdminAccountsForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAdminAccountsForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAdminAccountsForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AdminAccountSummary> adminAccounts() {
        Function<ListAdminAccountsForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.adminAccounts() != null) {
                return response.adminAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAdminAccountsForOrganizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAdminAccountsForOrganizationResponseFetcher
    implements AsyncPageFetcher<ListAdminAccountsForOrganizationResponse> {
        private ListAdminAccountsForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListAdminAccountsForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAdminAccountsForOrganizationResponse> nextPage(ListAdminAccountsForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListAdminAccountsForOrganizationPublisher.this.client.listAdminAccountsForOrganization(ListAdminAccountsForOrganizationPublisher.this.firstRequest);
            }
            return ListAdminAccountsForOrganizationPublisher.this.client.listAdminAccountsForOrganization((ListAdminAccountsForOrganizationRequest)((Object)ListAdminAccountsForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

