/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntryViolationReason {
    MISSING_EXPECTED_ENTRY("MISSING_EXPECTED_ENTRY"),
    INCORRECT_ENTRY_ORDER("INCORRECT_ENTRY_ORDER"),
    ENTRY_CONFLICT("ENTRY_CONFLICT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntryViolationReason> VALUE_MAP;
    private final String value;

    private EntryViolationReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntryViolationReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntryViolationReason> knownValues() {
        EnumSet<EntryViolationReason> knownValues = EnumSet.allOf(EntryViolationReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntryViolationReason.class, EntryViolationReason::toString);
    }
}

