/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.OrganizationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminAccountSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdminAccountSummary> {
    private static final SdkField<String> ADMIN_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdminAccount").getter(AdminAccountSummary.getter(AdminAccountSummary::adminAccount)).setter(AdminAccountSummary.setter(Builder::adminAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccount").build()}).build();
    private static final SdkField<Boolean> DEFAULT_ADMIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultAdmin").getter(AdminAccountSummary.getter(AdminAccountSummary::defaultAdmin)).setter(AdminAccountSummary.setter(Builder::defaultAdmin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAdmin").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AdminAccountSummary.getter(AdminAccountSummary::statusAsString)).setter(AdminAccountSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_FIELD, DEFAULT_ADMIN_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adminAccount;
    private final Boolean defaultAdmin;
    private final String status;

    private AdminAccountSummary(BuilderImpl builder) {
        this.adminAccount = builder.adminAccount;
        this.defaultAdmin = builder.defaultAdmin;
        this.status = builder.status;
    }

    public final String adminAccount() {
        return this.adminAccount;
    }

    public final Boolean defaultAdmin() {
        return this.defaultAdmin;
    }

    public final OrganizationStatus status() {
        return OrganizationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adminAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAdmin());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminAccountSummary)) {
            return false;
        }
        AdminAccountSummary other = (AdminAccountSummary)obj;
        return Objects.equals(this.adminAccount(), other.adminAccount()) && Objects.equals(this.defaultAdmin(), other.defaultAdmin()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AdminAccountSummary").add("AdminAccount", (Object)this.adminAccount()).add("DefaultAdmin", (Object)this.defaultAdmin()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminAccount": {
                return Optional.ofNullable(clazz.cast(this.adminAccount()));
            }
            case "DefaultAdmin": {
                return Optional.ofNullable(clazz.cast(this.defaultAdmin()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminAccountSummary, T> g) {
        return obj -> g.apply((AdminAccountSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adminAccount;
        private Boolean defaultAdmin;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminAccountSummary model) {
            this.adminAccount(model.adminAccount);
            this.defaultAdmin(model.defaultAdmin);
            this.status(model.status);
        }

        public final String getAdminAccount() {
            return this.adminAccount;
        }

        public final void setAdminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
        }

        @Override
        public final Builder adminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
            return this;
        }

        public final Boolean getDefaultAdmin() {
            return this.defaultAdmin;
        }

        public final void setDefaultAdmin(Boolean defaultAdmin) {
            this.defaultAdmin = defaultAdmin;
        }

        @Override
        public final Builder defaultAdmin(Boolean defaultAdmin) {
            this.defaultAdmin = defaultAdmin;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public AdminAccountSummary build() {
            return new AdminAccountSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdminAccountSummary> {
        public Builder adminAccount(String var1);

        public Builder defaultAdmin(Boolean var1);

        public Builder status(String var1);

        public Builder status(OrganizationStatus var1);
    }
}

