/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsClient;
import software.amazon.awssdk.services.fms.internal.UserAgentUtils;
import software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest;
import software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse;
import software.amazon.awssdk.services.fms.model.PolicyComplianceStatus;

public class ListComplianceStatusIterable
implements SdkIterable<ListComplianceStatusResponse> {
    private final FmsClient client;
    private final ListComplianceStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComplianceStatusIterable(FmsClient client, ListComplianceStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComplianceStatusResponseFetcher();
    }

    public Iterator<ListComplianceStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyComplianceStatus> policyComplianceStatusList() {
        Function<ListComplianceStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyComplianceStatusList() != null) {
                return response.policyComplianceStatusList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComplianceStatusResponseFetcher
    implements SyncPageFetcher<ListComplianceStatusResponse> {
        private ListComplianceStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListComplianceStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComplianceStatusResponse nextPage(ListComplianceStatusResponse previousPage) {
            if (previousPage == null) {
                return ListComplianceStatusIterable.this.client.listComplianceStatus(ListComplianceStatusIterable.this.firstRequest);
            }
            return ListComplianceStatusIterable.this.client.listComplianceStatus((ListComplianceStatusRequest)((Object)ListComplianceStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

