/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsAsyncClient;
import software.amazon.awssdk.services.fms.model.AppsListDataSummary;
import software.amazon.awssdk.services.fms.model.ListAppsListsRequest;
import software.amazon.awssdk.services.fms.model.ListAppsListsResponse;

public class ListAppsListsPublisher
implements SdkPublisher<ListAppsListsResponse> {
    private final FmsAsyncClient client;
    private final ListAppsListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppsListsPublisher(FmsAsyncClient client, ListAppsListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppsListsPublisher(FmsAsyncClient client, ListAppsListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppsListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppsListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AppsListDataSummary> appsLists() {
        Function<ListAppsListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.appsLists() != null) {
                return response.appsLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAppsListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAppsListsResponseFetcher
    implements AsyncPageFetcher<ListAppsListsResponse> {
        private ListAppsListsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppsListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppsListsResponse> nextPage(ListAppsListsResponse previousPage) {
            if (previousPage == null) {
                return ListAppsListsPublisher.this.client.listAppsLists(ListAppsListsPublisher.this.firstRequest);
            }
            return ListAppsListsPublisher.this.client.listAppsLists((ListAppsListsRequest)((Object)ListAppsListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

