/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.fms.DefaultFmsBaseClientBuilder;
import software.amazon.awssdk.services.fms.DefaultFmsClient;
import software.amazon.awssdk.services.fms.FmsClient;
import software.amazon.awssdk.services.fms.FmsClientBuilder;
import software.amazon.awssdk.services.fms.FmsServiceClientConfiguration;
import software.amazon.awssdk.services.fms.endpoints.FmsEndpointProvider;

@SdkInternalApi
final class DefaultFmsClientBuilder
extends DefaultFmsBaseClientBuilder<FmsClientBuilder, FmsClient>
implements FmsClientBuilder {
    DefaultFmsClientBuilder() {
    }

    @Override
    public DefaultFmsClientBuilder endpointProvider(FmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FmsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFmsClientBuilder.validateClientOptions(clientConfiguration);
        FmsServiceClientConfiguration serviceClientConfiguration = FmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultFmsClient(serviceClientConfiguration, clientConfiguration);
    }
}

