/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.PolicyOption;
import software.amazon.awssdk.services.fms.model.SecurityServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityServicePolicyData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityServicePolicyData> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SecurityServicePolicyData.getter(SecurityServicePolicyData::typeAsString)).setter(SecurityServicePolicyData.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> MANAGED_SERVICE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedServiceData").getter(SecurityServicePolicyData.getter(SecurityServicePolicyData::managedServiceData)).setter(SecurityServicePolicyData.setter(Builder::managedServiceData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedServiceData").build()}).build();
    private static final SdkField<PolicyOption> POLICY_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyOption").getter(SecurityServicePolicyData.getter(SecurityServicePolicyData::policyOption)).setter(SecurityServicePolicyData.setter(Builder::policyOption)).constructor(PolicyOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MANAGED_SERVICE_DATA_FIELD, POLICY_OPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String managedServiceData;
    private final PolicyOption policyOption;

    private SecurityServicePolicyData(BuilderImpl builder) {
        this.type = builder.type;
        this.managedServiceData = builder.managedServiceData;
        this.policyOption = builder.policyOption;
    }

    public final SecurityServiceType type() {
        return SecurityServiceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String managedServiceData() {
        return this.managedServiceData;
    }

    public final PolicyOption policyOption() {
        return this.policyOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedServiceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyOption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityServicePolicyData)) {
            return false;
        }
        SecurityServicePolicyData other = (SecurityServicePolicyData)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.managedServiceData(), other.managedServiceData()) && Objects.equals(this.policyOption(), other.policyOption());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityServicePolicyData").add("Type", (Object)this.typeAsString()).add("ManagedServiceData", (Object)this.managedServiceData()).add("PolicyOption", (Object)this.policyOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ManagedServiceData": {
                return Optional.ofNullable(clazz.cast(this.managedServiceData()));
            }
            case "PolicyOption": {
                return Optional.ofNullable(clazz.cast(this.policyOption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityServicePolicyData, T> g) {
        return obj -> g.apply((SecurityServicePolicyData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String managedServiceData;
        private PolicyOption policyOption;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityServicePolicyData model) {
            this.type(model.type);
            this.managedServiceData(model.managedServiceData);
            this.policyOption(model.policyOption);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityServiceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getManagedServiceData() {
            return this.managedServiceData;
        }

        public final void setManagedServiceData(String managedServiceData) {
            this.managedServiceData = managedServiceData;
        }

        @Override
        public final Builder managedServiceData(String managedServiceData) {
            this.managedServiceData = managedServiceData;
            return this;
        }

        public final PolicyOption.Builder getPolicyOption() {
            return this.policyOption != null ? this.policyOption.toBuilder() : null;
        }

        public final void setPolicyOption(PolicyOption.BuilderImpl policyOption) {
            this.policyOption = policyOption != null ? policyOption.build() : null;
        }

        @Override
        public final Builder policyOption(PolicyOption policyOption) {
            this.policyOption = policyOption;
            return this;
        }

        public SecurityServicePolicyData build() {
            return new SecurityServicePolicyData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityServicePolicyData> {
        public Builder type(String var1);

        public Builder type(SecurityServiceType var1);

        public Builder managedServiceData(String var1);

        public Builder policyOption(PolicyOption var1);

        default public Builder policyOption(Consumer<PolicyOption.Builder> policyOption) {
            return this.policyOption((PolicyOption)((PolicyOption.Builder)PolicyOption.builder().applyMutation(policyOption)).build());
        }
    }
}

