/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.RemediationActionType;
import software.amazon.awssdk.services.fms.model.SecurityGroupRuleDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroupRemediationAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroupRemediationAction> {
    private static final SdkField<String> REMEDIATION_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemediationActionType").getter(SecurityGroupRemediationAction.getter(SecurityGroupRemediationAction::remediationActionTypeAsString)).setter(SecurityGroupRemediationAction.setter(Builder::remediationActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationActionType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SecurityGroupRemediationAction.getter(SecurityGroupRemediationAction::description)).setter(SecurityGroupRemediationAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<SecurityGroupRuleDescription> REMEDIATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemediationResult").getter(SecurityGroupRemediationAction.getter(SecurityGroupRemediationAction::remediationResult)).setter(SecurityGroupRemediationAction.setter(Builder::remediationResult)).constructor(SecurityGroupRuleDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationResult").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefaultAction").getter(SecurityGroupRemediationAction.getter(SecurityGroupRemediationAction::isDefaultAction)).setter(SecurityGroupRemediationAction.setter(Builder::isDefaultAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMEDIATION_ACTION_TYPE_FIELD, DESCRIPTION_FIELD, REMEDIATION_RESULT_FIELD, IS_DEFAULT_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String remediationActionType;
    private final String description;
    private final SecurityGroupRuleDescription remediationResult;
    private final Boolean isDefaultAction;

    private SecurityGroupRemediationAction(BuilderImpl builder) {
        this.remediationActionType = builder.remediationActionType;
        this.description = builder.description;
        this.remediationResult = builder.remediationResult;
        this.isDefaultAction = builder.isDefaultAction;
    }

    public final RemediationActionType remediationActionType() {
        return RemediationActionType.fromValue(this.remediationActionType);
    }

    public final String remediationActionTypeAsString() {
        return this.remediationActionType;
    }

    public final String description() {
        return this.description;
    }

    public final SecurityGroupRuleDescription remediationResult() {
        return this.remediationResult;
    }

    public final Boolean isDefaultAction() {
        return this.isDefaultAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupRemediationAction)) {
            return false;
        }
        SecurityGroupRemediationAction other = (SecurityGroupRemediationAction)obj;
        return Objects.equals(this.remediationActionTypeAsString(), other.remediationActionTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.remediationResult(), other.remediationResult()) && Objects.equals(this.isDefaultAction(), other.isDefaultAction());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroupRemediationAction").add("RemediationActionType", (Object)this.remediationActionTypeAsString()).add("Description", (Object)this.description()).add("RemediationResult", (Object)this.remediationResult()).add("IsDefaultAction", (Object)this.isDefaultAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RemediationActionType": {
                return Optional.ofNullable(clazz.cast(this.remediationActionTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RemediationResult": {
                return Optional.ofNullable(clazz.cast(this.remediationResult()));
            }
            case "IsDefaultAction": {
                return Optional.ofNullable(clazz.cast(this.isDefaultAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupRemediationAction, T> g) {
        return obj -> g.apply((SecurityGroupRemediationAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String remediationActionType;
        private String description;
        private SecurityGroupRuleDescription remediationResult;
        private Boolean isDefaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupRemediationAction model) {
            this.remediationActionType(model.remediationActionType);
            this.description(model.description);
            this.remediationResult(model.remediationResult);
            this.isDefaultAction(model.isDefaultAction);
        }

        public final String getRemediationActionType() {
            return this.remediationActionType;
        }

        public final void setRemediationActionType(String remediationActionType) {
            this.remediationActionType = remediationActionType;
        }

        @Override
        @Transient
        public final Builder remediationActionType(String remediationActionType) {
            this.remediationActionType = remediationActionType;
            return this;
        }

        @Override
        @Transient
        public final Builder remediationActionType(RemediationActionType remediationActionType) {
            this.remediationActionType(remediationActionType == null ? null : remediationActionType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SecurityGroupRuleDescription.Builder getRemediationResult() {
            return this.remediationResult != null ? this.remediationResult.toBuilder() : null;
        }

        public final void setRemediationResult(SecurityGroupRuleDescription.BuilderImpl remediationResult) {
            this.remediationResult = remediationResult != null ? remediationResult.build() : null;
        }

        @Override
        @Transient
        public final Builder remediationResult(SecurityGroupRuleDescription remediationResult) {
            this.remediationResult = remediationResult;
            return this;
        }

        public final Boolean getIsDefaultAction() {
            return this.isDefaultAction;
        }

        public final void setIsDefaultAction(Boolean isDefaultAction) {
            this.isDefaultAction = isDefaultAction;
        }

        @Override
        @Transient
        public final Builder isDefaultAction(Boolean isDefaultAction) {
            this.isDefaultAction = isDefaultAction;
            return this;
        }

        public SecurityGroupRemediationAction build() {
            return new SecurityGroupRemediationAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroupRemediationAction> {
        public Builder remediationActionType(String var1);

        public Builder remediationActionType(RemediationActionType var1);

        public Builder description(String var1);

        public Builder remediationResult(SecurityGroupRuleDescription var1);

        default public Builder remediationResult(Consumer<SecurityGroupRuleDescription.Builder> remediationResult) {
            return this.remediationResult((SecurityGroupRuleDescription)((SecurityGroupRuleDescription.Builder)SecurityGroupRuleDescription.builder().applyMutation(remediationResult)).build());
        }

        public Builder isDefaultAction(Boolean var1);
    }
}

