/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the resource that is not protected by the policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceViolator implements SdkPojo, Serializable,
        ToCopyableBuilder<ComplianceViolator.Builder, ComplianceViolator> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ComplianceViolator::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> VIOLATION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationReason").getter(getter(ComplianceViolator::violationReasonAsString))
            .setter(setter(Builder::violationReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationReason").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ComplianceViolator::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            VIOLATION_REASON_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String violationReason;

    private final String resourceType;

    private ComplianceViolator(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.violationReason = builder.violationReason;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The resource ID.
     * </p>
     * 
     * @return The resource ID.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The reason that the resource is not protected by the policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #violationReason}
     * will return {@link ViolationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #violationReasonAsString}.
     * </p>
     * 
     * @return The reason that the resource is not protected by the policy.
     * @see ViolationReason
     */
    public final ViolationReason violationReason() {
        return ViolationReason.fromValue(violationReason);
    }

    /**
     * <p>
     * The reason that the resource is not protected by the policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #violationReason}
     * will return {@link ViolationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #violationReasonAsString}.
     * </p>
     * 
     * @return The reason that the resource is not protected by the policy.
     * @see ViolationReason
     */
    public final String violationReasonAsString() {
        return violationReason;
    }

    /**
     * <p>
     * The resource type. This is in the format shown in the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS
     * Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>,
     * <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.
     * </p>
     * 
     * @return The resource type. This is in the format shown in the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >AWS Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>,
     *         <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(violationReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceViolator)) {
            return false;
        }
        ComplianceViolator other = (ComplianceViolator) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(violationReasonAsString(), other.violationReasonAsString())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComplianceViolator").add("ResourceId", resourceId())
                .add("ViolationReason", violationReasonAsString()).add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ViolationReason":
            return Optional.ofNullable(clazz.cast(violationReasonAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceViolator, T> g) {
        return obj -> g.apply((ComplianceViolator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComplianceViolator> {
        /**
         * <p>
         * The resource ID.
         * </p>
         * 
         * @param resourceId
         *        The resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The reason that the resource is not protected by the policy.
         * </p>
         * 
         * @param violationReason
         *        The reason that the resource is not protected by the policy.
         * @see ViolationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViolationReason
         */
        Builder violationReason(String violationReason);

        /**
         * <p>
         * The reason that the resource is not protected by the policy.
         * </p>
         * 
         * @param violationReason
         *        The reason that the resource is not protected by the policy.
         * @see ViolationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViolationReason
         */
        Builder violationReason(ViolationReason violationReason);

        /**
         * <p>
         * The resource type. This is in the format shown in the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS
         * Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>,
         * <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.
         * </p>
         * 
         * @param resourceType
         *        The resource type. This is in the format shown in the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >AWS Resource Types Reference</a>. For example: <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code>
         *        , <code>AWS::CloudFront::Distribution</code>, or <code>AWS::NetworkFirewall::FirewallPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String violationReason;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceViolator model) {
            resourceId(model.resourceId);
            violationReason(model.violationReason);
            resourceType(model.resourceType);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getViolationReason() {
            return violationReason;
        }

        @Override
        public final Builder violationReason(String violationReason) {
            this.violationReason = violationReason;
            return this;
        }

        @Override
        public final Builder violationReason(ViolationReason violationReason) {
            this.violationReason(violationReason == null ? null : violationReason.toString());
            return this;
        }

        public final void setViolationReason(String violationReason) {
            this.violationReason = violationReason;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public ComplianceViolator build() {
            return new ComplianceViolator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
