/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType;
import software.amazon.awssdk.services.fms.model.CustomerPolicyScopeMapCopier;
import software.amazon.awssdk.services.fms.model.ResourceTag;
import software.amazon.awssdk.services.fms.model.ResourceTagsCopier;
import software.amazon.awssdk.services.fms.model.ResourceTypeListCopier;
import software.amazon.awssdk.services.fms.model.SecurityServicePolicyData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Policy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Policy> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Policy.getter(Policy::policyId)).setter(Policy.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Policy.getter(Policy::policyName)).setter(Policy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Policy.getter(Policy::policyUpdateToken)).setter(Policy.setter(Builder::policyUpdateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyUpdateToken").build()}).build();
    private static final SdkField<SecurityServicePolicyData> SECURITY_SERVICE_POLICY_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Policy.getter(Policy::securityServicePolicyData)).setter(Policy.setter(Builder::securityServicePolicyData)).constructor(SecurityServicePolicyData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityServicePolicyData").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Policy.getter(Policy::resourceType)).setter(Policy.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Policy.getter(Policy::resourceTypeList)).setter(Policy.setter(Builder::resourceTypeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Policy.getter(Policy::resourceTags)).setter(Policy.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EXCLUDE_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Policy.getter(Policy::excludeResourceTags)).setter(Policy.setter(Builder::excludeResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeResourceTags").build()}).build();
    private static final SdkField<Boolean> REMEDIATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Policy.getter(Policy::remediationEnabled)).setter(Policy.setter(Builder::remediationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationEnabled").build()}).build();
    private static final SdkField<Map<String, List<String>>> INCLUDE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Policy.getter(Policy::includeMapAsStrings)).setter(Policy.setter(Builder::includeMapWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> EXCLUDE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Policy.getter(Policy::excludeMapAsStrings)).setter(Policy.setter(Builder::excludeMapWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, POLICY_NAME_FIELD, POLICY_UPDATE_TOKEN_FIELD, SECURITY_SERVICE_POLICY_DATA_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TYPE_LIST_FIELD, RESOURCE_TAGS_FIELD, EXCLUDE_RESOURCE_TAGS_FIELD, REMEDIATION_ENABLED_FIELD, INCLUDE_MAP_FIELD, EXCLUDE_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyId;
    private final String policyName;
    private final String policyUpdateToken;
    private final SecurityServicePolicyData securityServicePolicyData;
    private final String resourceType;
    private final List<String> resourceTypeList;
    private final List<ResourceTag> resourceTags;
    private final Boolean excludeResourceTags;
    private final Boolean remediationEnabled;
    private final Map<String, List<String>> includeMap;
    private final Map<String, List<String>> excludeMap;

    private Policy(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.policyName = builder.policyName;
        this.policyUpdateToken = builder.policyUpdateToken;
        this.securityServicePolicyData = builder.securityServicePolicyData;
        this.resourceType = builder.resourceType;
        this.resourceTypeList = builder.resourceTypeList;
        this.resourceTags = builder.resourceTags;
        this.excludeResourceTags = builder.excludeResourceTags;
        this.remediationEnabled = builder.remediationEnabled;
        this.includeMap = builder.includeMap;
        this.excludeMap = builder.excludeMap;
    }

    public String policyId() {
        return this.policyId;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyUpdateToken() {
        return this.policyUpdateToken;
    }

    public SecurityServicePolicyData securityServicePolicyData() {
        return this.securityServicePolicyData;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public boolean hasResourceTypeList() {
        return this.resourceTypeList != null && !(this.resourceTypeList instanceof SdkAutoConstructList);
    }

    public List<String> resourceTypeList() {
        return this.resourceTypeList;
    }

    public boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public Boolean excludeResourceTags() {
        return this.excludeResourceTags;
    }

    public Boolean remediationEnabled() {
        return this.remediationEnabled;
    }

    public Map<CustomerPolicyScopeIdType, List<String>> includeMap() {
        return CustomerPolicyScopeMapCopier.copyStringToEnum(this.includeMap);
    }

    public boolean hasIncludeMap() {
        return this.includeMap != null && !(this.includeMap instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> includeMapAsStrings() {
        return this.includeMap;
    }

    public Map<CustomerPolicyScopeIdType, List<String>> excludeMap() {
        return CustomerPolicyScopeMapCopier.copyStringToEnum(this.excludeMap);
    }

    public boolean hasExcludeMap() {
        return this.excludeMap != null && !(this.excludeMap instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> excludeMapAsStrings() {
        return this.excludeMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyUpdateToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityServicePolicyData());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeResourceTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMapAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeMapAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyUpdateToken(), other.policyUpdateToken()) && Objects.equals(this.securityServicePolicyData(), other.securityServicePolicyData()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceTypeList(), other.resourceTypeList()) && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.excludeResourceTags(), other.excludeResourceTags()) && Objects.equals(this.remediationEnabled(), other.remediationEnabled()) && Objects.equals(this.includeMapAsStrings(), other.includeMapAsStrings()) && Objects.equals(this.excludeMapAsStrings(), other.excludeMapAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Policy").add("PolicyId", (Object)this.policyId()).add("PolicyName", (Object)this.policyName()).add("PolicyUpdateToken", (Object)this.policyUpdateToken()).add("SecurityServicePolicyData", (Object)this.securityServicePolicyData()).add("ResourceType", (Object)this.resourceType()).add("ResourceTypeList", this.resourceTypeList()).add("ResourceTags", this.resourceTags()).add("ExcludeResourceTags", (Object)this.excludeResourceTags()).add("RemediationEnabled", (Object)this.remediationEnabled()).add("IncludeMap", this.includeMapAsStrings()).add("ExcludeMap", this.excludeMapAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyUpdateToken": {
                return Optional.ofNullable(clazz.cast(this.policyUpdateToken()));
            }
            case "SecurityServicePolicyData": {
                return Optional.ofNullable(clazz.cast(this.securityServicePolicyData()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceTypeList": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeList()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "ExcludeResourceTags": {
                return Optional.ofNullable(clazz.cast(this.excludeResourceTags()));
            }
            case "RemediationEnabled": {
                return Optional.ofNullable(clazz.cast(this.remediationEnabled()));
            }
            case "IncludeMap": {
                return Optional.ofNullable(clazz.cast(this.includeMapAsStrings()));
            }
            case "ExcludeMap": {
                return Optional.ofNullable(clazz.cast(this.excludeMapAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Policy, T> g) {
        return obj -> g.apply((Policy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String policyName;
        private String policyUpdateToken;
        private SecurityServicePolicyData securityServicePolicyData;
        private String resourceType;
        private List<String> resourceTypeList = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private Boolean excludeResourceTags;
        private Boolean remediationEnabled;
        private Map<String, List<String>> includeMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> excludeMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            this.policyId(model.policyId);
            this.policyName(model.policyName);
            this.policyUpdateToken(model.policyUpdateToken);
            this.securityServicePolicyData(model.securityServicePolicyData);
            this.resourceType(model.resourceType);
            this.resourceTypeList(model.resourceTypeList);
            this.resourceTags(model.resourceTags);
            this.excludeResourceTags(model.excludeResourceTags);
            this.remediationEnabled(model.remediationEnabled);
            this.includeMapWithStrings(model.includeMap);
            this.excludeMapWithStrings(model.excludeMap);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyUpdateToken() {
            return this.policyUpdateToken;
        }

        @Override
        public final Builder policyUpdateToken(String policyUpdateToken) {
            this.policyUpdateToken = policyUpdateToken;
            return this;
        }

        public final void setPolicyUpdateToken(String policyUpdateToken) {
            this.policyUpdateToken = policyUpdateToken;
        }

        public final SecurityServicePolicyData.Builder getSecurityServicePolicyData() {
            return this.securityServicePolicyData != null ? this.securityServicePolicyData.toBuilder() : null;
        }

        @Override
        public final Builder securityServicePolicyData(SecurityServicePolicyData securityServicePolicyData) {
            this.securityServicePolicyData = securityServicePolicyData;
            return this;
        }

        public final void setSecurityServicePolicyData(SecurityServicePolicyData.BuilderImpl securityServicePolicyData) {
            this.securityServicePolicyData = securityServicePolicyData != null ? securityServicePolicyData.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceTypeList() {
            return this.resourceTypeList;
        }

        @Override
        public final Builder resourceTypeList(Collection<String> resourceTypeList) {
            this.resourceTypeList = ResourceTypeListCopier.copy(resourceTypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeList(String ... resourceTypeList) {
            this.resourceTypeList(Arrays.asList(resourceTypeList));
            return this;
        }

        public final void setResourceTypeList(Collection<String> resourceTypeList) {
            this.resourceTypeList = ResourceTypeListCopier.copy(resourceTypeList);
        }

        public final Collection<ResourceTag.Builder> getResourceTags() {
            return this.resourceTags != null ? (Collection)this.resourceTags.stream().map(ResourceTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        public final Boolean getExcludeResourceTags() {
            return this.excludeResourceTags;
        }

        @Override
        public final Builder excludeResourceTags(Boolean excludeResourceTags) {
            this.excludeResourceTags = excludeResourceTags;
            return this;
        }

        public final void setExcludeResourceTags(Boolean excludeResourceTags) {
            this.excludeResourceTags = excludeResourceTags;
        }

        public final Boolean getRemediationEnabled() {
            return this.remediationEnabled;
        }

        @Override
        public final Builder remediationEnabled(Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
            return this;
        }

        public final void setRemediationEnabled(Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
        }

        public final Map<String, ? extends Collection<String>> getIncludeMap() {
            return this.includeMap;
        }

        @Override
        public final Builder includeMapWithStrings(Map<String, ? extends Collection<String>> includeMap) {
            this.includeMap = CustomerPolicyScopeMapCopier.copy(includeMap);
            return this;
        }

        @Override
        public final Builder includeMap(Map<CustomerPolicyScopeIdType, ? extends Collection<String>> includeMap) {
            this.includeMap = CustomerPolicyScopeMapCopier.copyEnumToString(includeMap);
            return this;
        }

        public final void setIncludeMap(Map<String, ? extends Collection<String>> includeMap) {
            this.includeMap = CustomerPolicyScopeMapCopier.copy(includeMap);
        }

        public final Map<String, ? extends Collection<String>> getExcludeMap() {
            return this.excludeMap;
        }

        @Override
        public final Builder excludeMapWithStrings(Map<String, ? extends Collection<String>> excludeMap) {
            this.excludeMap = CustomerPolicyScopeMapCopier.copy(excludeMap);
            return this;
        }

        @Override
        public final Builder excludeMap(Map<CustomerPolicyScopeIdType, ? extends Collection<String>> excludeMap) {
            this.excludeMap = CustomerPolicyScopeMapCopier.copyEnumToString(excludeMap);
            return this;
        }

        public final void setExcludeMap(Map<String, ? extends Collection<String>> excludeMap) {
            this.excludeMap = CustomerPolicyScopeMapCopier.copy(excludeMap);
        }

        public Policy build() {
            return new Policy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Policy> {
        public Builder policyId(String var1);

        public Builder policyName(String var1);

        public Builder policyUpdateToken(String var1);

        public Builder securityServicePolicyData(SecurityServicePolicyData var1);

        default public Builder securityServicePolicyData(Consumer<SecurityServicePolicyData.Builder> securityServicePolicyData) {
            return this.securityServicePolicyData((SecurityServicePolicyData)((SecurityServicePolicyData.Builder)SecurityServicePolicyData.builder().applyMutation(securityServicePolicyData)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceTypeList(Collection<String> var1);

        public Builder resourceTypeList(String ... var1);

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder excludeResourceTags(Boolean var1);

        public Builder remediationEnabled(Boolean var1);

        public Builder includeMapWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder includeMap(Map<CustomerPolicyScopeIdType, ? extends Collection<String>> var1);

        public Builder excludeMapWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder excludeMap(Map<CustomerPolicyScopeIdType, ? extends Collection<String>> var1);
    }
}

