/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.fms.model.ComplianceViolator;
import software.amazon.awssdk.services.fms.model.ComplianceViolatorsCopier;
import software.amazon.awssdk.services.fms.model.DependentServiceName;
import software.amazon.awssdk.services.fms.model.IssueInfoMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyComplianceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyComplianceDetail> {
    private static final SdkField<String> POLICY_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyComplianceDetail.getter(PolicyComplianceDetail::policyOwner)).setter(PolicyComplianceDetail.setter(Builder::policyOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyOwner").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyComplianceDetail.getter(PolicyComplianceDetail::policyId)).setter(PolicyComplianceDetail.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> MEMBER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyComplianceDetail.getter(PolicyComplianceDetail::memberAccount)).setter(PolicyComplianceDetail.setter(Builder::memberAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccount").build()}).build();
    private static final SdkField<List<ComplianceViolator>> VIOLATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PolicyComplianceDetail.getter(PolicyComplianceDetail::violators)).setter(PolicyComplianceDetail.setter(Builder::violators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Violators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComplianceViolator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EVALUATION_LIMIT_EXCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PolicyComplianceDetail.getter(PolicyComplianceDetail::evaluationLimitExceeded)).setter(PolicyComplianceDetail.setter(Builder::evaluationLimitExceeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationLimitExceeded").build()}).build();
    private static final SdkField<Instant> EXPIRED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PolicyComplianceDetail.getter(PolicyComplianceDetail::expiredAt)).setter(PolicyComplianceDetail.setter(Builder::expiredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiredAt").build()}).build();
    private static final SdkField<Map<String, String>> ISSUE_INFO_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(PolicyComplianceDetail.getter(PolicyComplianceDetail::issueInfoMapAsStrings)).setter(PolicyComplianceDetail.setter(Builder::issueInfoMapWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueInfoMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_OWNER_FIELD, POLICY_ID_FIELD, MEMBER_ACCOUNT_FIELD, VIOLATORS_FIELD, EVALUATION_LIMIT_EXCEEDED_FIELD, EXPIRED_AT_FIELD, ISSUE_INFO_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyOwner;
    private final String policyId;
    private final String memberAccount;
    private final List<ComplianceViolator> violators;
    private final Boolean evaluationLimitExceeded;
    private final Instant expiredAt;
    private final Map<String, String> issueInfoMap;

    private PolicyComplianceDetail(BuilderImpl builder) {
        this.policyOwner = builder.policyOwner;
        this.policyId = builder.policyId;
        this.memberAccount = builder.memberAccount;
        this.violators = builder.violators;
        this.evaluationLimitExceeded = builder.evaluationLimitExceeded;
        this.expiredAt = builder.expiredAt;
        this.issueInfoMap = builder.issueInfoMap;
    }

    public String policyOwner() {
        return this.policyOwner;
    }

    public String policyId() {
        return this.policyId;
    }

    public String memberAccount() {
        return this.memberAccount;
    }

    public List<ComplianceViolator> violators() {
        return this.violators;
    }

    public Boolean evaluationLimitExceeded() {
        return this.evaluationLimitExceeded;
    }

    public Instant expiredAt() {
        return this.expiredAt;
    }

    public Map<DependentServiceName, String> issueInfoMap() {
        return IssueInfoMapCopier.copyStringToEnum(this.issueInfoMap);
    }

    public Map<String, String> issueInfoMapAsStrings() {
        return this.issueInfoMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.violators());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationLimitExceeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiredAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueInfoMapAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyComplianceDetail)) {
            return false;
        }
        PolicyComplianceDetail other = (PolicyComplianceDetail)obj;
        return Objects.equals(this.policyOwner(), other.policyOwner()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.memberAccount(), other.memberAccount()) && Objects.equals(this.violators(), other.violators()) && Objects.equals(this.evaluationLimitExceeded(), other.evaluationLimitExceeded()) && Objects.equals(this.expiredAt(), other.expiredAt()) && Objects.equals(this.issueInfoMapAsStrings(), other.issueInfoMapAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"PolicyComplianceDetail").add("PolicyOwner", (Object)this.policyOwner()).add("PolicyId", (Object)this.policyId()).add("MemberAccount", (Object)this.memberAccount()).add("Violators", this.violators()).add("EvaluationLimitExceeded", (Object)this.evaluationLimitExceeded()).add("ExpiredAt", (Object)this.expiredAt()).add("IssueInfoMap", this.issueInfoMapAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyOwner": {
                return Optional.ofNullable(clazz.cast(this.policyOwner()));
            }
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "MemberAccount": {
                return Optional.ofNullable(clazz.cast(this.memberAccount()));
            }
            case "Violators": {
                return Optional.ofNullable(clazz.cast(this.violators()));
            }
            case "EvaluationLimitExceeded": {
                return Optional.ofNullable(clazz.cast(this.evaluationLimitExceeded()));
            }
            case "ExpiredAt": {
                return Optional.ofNullable(clazz.cast(this.expiredAt()));
            }
            case "IssueInfoMap": {
                return Optional.ofNullable(clazz.cast(this.issueInfoMapAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyComplianceDetail, T> g) {
        return obj -> g.apply((PolicyComplianceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyOwner;
        private String policyId;
        private String memberAccount;
        private List<ComplianceViolator> violators = DefaultSdkAutoConstructList.getInstance();
        private Boolean evaluationLimitExceeded;
        private Instant expiredAt;
        private Map<String, String> issueInfoMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyComplianceDetail model) {
            this.policyOwner(model.policyOwner);
            this.policyId(model.policyId);
            this.memberAccount(model.memberAccount);
            this.violators(model.violators);
            this.evaluationLimitExceeded(model.evaluationLimitExceeded);
            this.expiredAt(model.expiredAt);
            this.issueInfoMapWithStrings(model.issueInfoMap);
        }

        public final String getPolicyOwner() {
            return this.policyOwner;
        }

        @Override
        public final Builder policyOwner(String policyOwner) {
            this.policyOwner = policyOwner;
            return this;
        }

        public final void setPolicyOwner(String policyOwner) {
            this.policyOwner = policyOwner;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getMemberAccount() {
            return this.memberAccount;
        }

        @Override
        public final Builder memberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
            return this;
        }

        public final void setMemberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
        }

        public final Collection<ComplianceViolator.Builder> getViolators() {
            return this.violators != null ? (Collection)this.violators.stream().map(ComplianceViolator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder violators(Collection<ComplianceViolator> violators) {
            this.violators = ComplianceViolatorsCopier.copy(violators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violators(ComplianceViolator ... violators) {
            this.violators(Arrays.asList(violators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violators(Consumer<ComplianceViolator.Builder> ... violators) {
            this.violators(Stream.of(violators).map(c -> (ComplianceViolator)((ComplianceViolator.Builder)ComplianceViolator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setViolators(Collection<ComplianceViolator.BuilderImpl> violators) {
            this.violators = ComplianceViolatorsCopier.copyFromBuilder(violators);
        }

        public final Boolean getEvaluationLimitExceeded() {
            return this.evaluationLimitExceeded;
        }

        @Override
        public final Builder evaluationLimitExceeded(Boolean evaluationLimitExceeded) {
            this.evaluationLimitExceeded = evaluationLimitExceeded;
            return this;
        }

        public final void setEvaluationLimitExceeded(Boolean evaluationLimitExceeded) {
            this.evaluationLimitExceeded = evaluationLimitExceeded;
        }

        public final Instant getExpiredAt() {
            return this.expiredAt;
        }

        @Override
        public final Builder expiredAt(Instant expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        public final void setExpiredAt(Instant expiredAt) {
            this.expiredAt = expiredAt;
        }

        public final Map<String, String> getIssueInfoMapAsStrings() {
            return this.issueInfoMap;
        }

        @Override
        public final Builder issueInfoMapWithStrings(Map<String, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copy(issueInfoMap);
            return this;
        }

        @Override
        public final Builder issueInfoMap(Map<DependentServiceName, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copyEnumToString(issueInfoMap);
            return this;
        }

        public final void setIssueInfoMapWithStrings(Map<String, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copy(issueInfoMap);
        }

        public PolicyComplianceDetail build() {
            return new PolicyComplianceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyComplianceDetail> {
        public Builder policyOwner(String var1);

        public Builder policyId(String var1);

        public Builder memberAccount(String var1);

        public Builder violators(Collection<ComplianceViolator> var1);

        public Builder violators(ComplianceViolator ... var1);

        public Builder violators(Consumer<ComplianceViolator.Builder> ... var1);

        public Builder evaluationLimitExceeded(Boolean var1);

        public Builder expiredAt(Instant var1);

        public Builder issueInfoMapWithStrings(Map<String, String> var1);

        public Builder issueInfoMap(Map<DependentServiceName, String> var1);
    }
}

