/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequestEntryListCopier;
import software.amazon.awssdk.services.firehose.model.Record;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordBatchRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, PutRecordBatchRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutRecordBatchRequest.getter(PutRecordBatchRequest::deliveryStreamName)).setter(PutRecordBatchRequest.setter(Builder::deliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build()}).build();
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutRecordBatchRequest.getter(PutRecordBatchRequest::records)).setter(PutRecordBatchRequest.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD, RECORDS_FIELD));
    private final String deliveryStreamName;
    private final List<Record> records;

    private PutRecordBatchRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.records = builder.records;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public List<Record> records() {
        return this.records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchRequest)) {
            return false;
        }
        PutRecordBatchRequest other = (PutRecordBatchRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.records(), other.records());
    }

    public String toString() {
        return ToString.builder((String)"PutRecordBatchRequest").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("Records", this.records()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordBatchRequest, T> g) {
        return obj -> g.apply((PutRecordBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchRequest model) {
            super(model);
            this.deliveryStreamName(model.deliveryStreamName);
            this.records(model.records);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = PutRecordBatchRequestEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = PutRecordBatchRequestEntryListCopier.copyFromBuilder(records);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecordBatchRequest build() {
            return new PutRecordBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordBatchRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

