/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxScalingGroup;
import software.amazon.awssdk.services.finspace.model.KxScalingGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKxScalingGroupsResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, ListKxScalingGroupsResponse> {
    private static final SdkField<List<KxScalingGroup>> SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scalingGroups").getter(ListKxScalingGroupsResponse.getter(ListKxScalingGroupsResponse::scalingGroups)).setter(ListKxScalingGroupsResponse.setter(Builder::scalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxScalingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListKxScalingGroupsResponse.getter(ListKxScalingGroupsResponse::nextToken)).setter(ListKxScalingGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListKxScalingGroupsResponse.memberNameToFieldInitializer();
    private final List<KxScalingGroup> scalingGroups;
    private final String nextToken;

    private ListKxScalingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.scalingGroups = builder.scalingGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScalingGroups() {
        return this.scalingGroups != null && !(this.scalingGroups instanceof SdkAutoConstructList);
    }

    public final List<KxScalingGroup> scalingGroups() {
        return this.scalingGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingGroups() ? this.scalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxScalingGroupsResponse)) {
            return false;
        }
        ListKxScalingGroupsResponse other = (ListKxScalingGroupsResponse)((Object)obj);
        return this.hasScalingGroups() == other.hasScalingGroups() && Objects.equals(this.scalingGroups(), other.scalingGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKxScalingGroupsResponse").add("ScalingGroups", this.hasScalingGroups() ? this.scalingGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scalingGroups": {
                return Optional.ofNullable(clazz.cast(this.scalingGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scalingGroups", SCALING_GROUPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKxScalingGroupsResponse, T> g) {
        return obj -> g.apply((ListKxScalingGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private List<KxScalingGroup> scalingGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxScalingGroupsResponse model) {
            super(model);
            this.scalingGroups(model.scalingGroups);
            this.nextToken(model.nextToken);
        }

        public final List<KxScalingGroup.Builder> getScalingGroups() {
            List<KxScalingGroup.Builder> result = KxScalingGroupListCopier.copyToBuilder(this.scalingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingGroups(Collection<KxScalingGroup.BuilderImpl> scalingGroups) {
            this.scalingGroups = KxScalingGroupListCopier.copyFromBuilder(scalingGroups);
        }

        @Override
        public final Builder scalingGroups(Collection<KxScalingGroup> scalingGroups) {
            this.scalingGroups = KxScalingGroupListCopier.copy(scalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingGroups(KxScalingGroup ... scalingGroups) {
            this.scalingGroups(Arrays.asList(scalingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingGroups(Consumer<KxScalingGroup.Builder> ... scalingGroups) {
            this.scalingGroups(Stream.of(scalingGroups).map(c -> (KxScalingGroup)((KxScalingGroup.Builder)KxScalingGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxScalingGroupsResponse build() {
            return new ListKxScalingGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKxScalingGroupsResponse> {
        public Builder scalingGroups(Collection<KxScalingGroup> var1);

        public Builder scalingGroups(KxScalingGroup ... var1);

        public Builder scalingGroups(Consumer<KxScalingGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

