/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoScalingMetric {
    CPU_UTILIZATION_PERCENTAGE("CPU_UTILIZATION_PERCENTAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoScalingMetric> VALUE_MAP;
    private final String value;

    private AutoScalingMetric(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoScalingMetric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoScalingMetric> knownValues() {
        EnumSet<AutoScalingMetric> knownValues = EnumSet.allOf(AutoScalingMetric.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoScalingMetric.class, AutoScalingMetric::toString);
    }
}

