/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse;

public class ListKxDatabasesPublisher
implements SdkPublisher<ListKxDatabasesResponse> {
    private final FinspaceAsyncClient client;
    private final ListKxDatabasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKxDatabasesPublisher(FinspaceAsyncClient client, ListKxDatabasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKxDatabasesPublisher(FinspaceAsyncClient client, ListKxDatabasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKxDatabasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKxDatabasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListKxDatabasesResponseFetcher
    implements AsyncPageFetcher<ListKxDatabasesResponse> {
        private ListKxDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(ListKxDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKxDatabasesResponse> nextPage(ListKxDatabasesResponse previousPage) {
            if (previousPage == null) {
                return ListKxDatabasesPublisher.this.client.listKxDatabases(ListKxDatabasesPublisher.this.firstRequest);
            }
            return ListKxDatabasesPublisher.this.client.listKxDatabases((ListKxDatabasesRequest)((Object)ListKxDatabasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

