/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleAction {
    ALLOW("allow"),
    DENY("deny"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleAction> VALUE_MAP;
    private final String value;

    private RuleAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleAction> knownValues() {
        EnumSet<RuleAction> knownValues = EnumSet.allOf(RuleAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleAction.class, RuleAction::toString);
    }
}

