/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceAsyncClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.KxEnvironment;
import software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsResponse;

public class ListKxEnvironmentsPublisher
implements SdkPublisher<ListKxEnvironmentsResponse> {
    private final FinspaceAsyncClient client;
    private final ListKxEnvironmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKxEnvironmentsPublisher(FinspaceAsyncClient client, ListKxEnvironmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKxEnvironmentsPublisher(FinspaceAsyncClient client, ListKxEnvironmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKxEnvironmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKxEnvironmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KxEnvironment> environments() {
        Function<ListKxEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environments() != null) {
                return response.environments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListKxEnvironmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListKxEnvironmentsResponseFetcher
    implements AsyncPageFetcher<ListKxEnvironmentsResponse> {
        private ListKxEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListKxEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKxEnvironmentsResponse> nextPage(ListKxEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListKxEnvironmentsPublisher.this.client.listKxEnvironments(ListKxEnvironmentsPublisher.this.firstRequest);
            }
            return ListKxEnvironmentsPublisher.this.client.listKxEnvironments((ListKxEnvironmentsRequest)((Object)ListKxEnvironmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

