/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayConfiguration> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transitGatewayID").getter(TransitGatewayConfiguration.getter(TransitGatewayConfiguration::transitGatewayID)).setter(TransitGatewayConfiguration.setter(Builder::transitGatewayID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitGatewayID").build()}).build();
    private static final SdkField<String> ROUTABLE_CIDR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("routableCIDRSpace").getter(TransitGatewayConfiguration.getter(TransitGatewayConfiguration::routableCIDRSpace)).setter(TransitGatewayConfiguration.setter(Builder::routableCIDRSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routableCIDRSpace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD, ROUTABLE_CIDR_SPACE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayID;
    private final String routableCIDRSpace;

    private TransitGatewayConfiguration(BuilderImpl builder) {
        this.transitGatewayID = builder.transitGatewayID;
        this.routableCIDRSpace = builder.routableCIDRSpace;
    }

    public final String transitGatewayID() {
        return this.transitGatewayID;
    }

    public final String routableCIDRSpace() {
        return this.routableCIDRSpace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayID());
        hashCode = 31 * hashCode + Objects.hashCode(this.routableCIDRSpace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConfiguration)) {
            return false;
        }
        TransitGatewayConfiguration other = (TransitGatewayConfiguration)obj;
        return Objects.equals(this.transitGatewayID(), other.transitGatewayID()) && Objects.equals(this.routableCIDRSpace(), other.routableCIDRSpace());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayConfiguration").add("TransitGatewayID", (Object)this.transitGatewayID()).add("RoutableCIDRSpace", (Object)this.routableCIDRSpace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transitGatewayID": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayID()));
            }
            case "routableCIDRSpace": {
                return Optional.ofNullable(clazz.cast(this.routableCIDRSpace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConfiguration, T> g) {
        return obj -> g.apply((TransitGatewayConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayID;
        private String routableCIDRSpace;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConfiguration model) {
            this.transitGatewayID(model.transitGatewayID);
            this.routableCIDRSpace(model.routableCIDRSpace);
        }

        public final String getTransitGatewayID() {
            return this.transitGatewayID;
        }

        public final void setTransitGatewayID(String transitGatewayID) {
            this.transitGatewayID = transitGatewayID;
        }

        @Override
        public final Builder transitGatewayID(String transitGatewayID) {
            this.transitGatewayID = transitGatewayID;
            return this;
        }

        public final String getRoutableCIDRSpace() {
            return this.routableCIDRSpace;
        }

        public final void setRoutableCIDRSpace(String routableCIDRSpace) {
            this.routableCIDRSpace = routableCIDRSpace;
        }

        @Override
        public final Builder routableCIDRSpace(String routableCIDRSpace) {
            this.routableCIDRSpace = routableCIDRSpace;
            return this;
        }

        public TransitGatewayConfiguration build() {
            return new TransitGatewayConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayConfiguration> {
        public Builder transitGatewayID(String var1);

        public Builder routableCIDRSpace(String var1);
    }
}

