/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VcfVersion {
    VCF_5_2_1("VCF-5.2.1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VcfVersion> VALUE_MAP;
    private final String value;

    private VcfVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VcfVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VcfVersion> knownValues() {
        EnumSet<VcfVersion> knownValues = EnumSet.allOf(VcfVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VcfVersion.class, VcfVersion::toString);
    }
}

