/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.EntityOverrideMapCopier;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy;
import software.amazon.awssdk.services.evidently.model.TagMapCopier;
import software.amazon.awssdk.services.evidently.model.VariationConfig;
import software.amazon.awssdk.services.evidently.model.VariationConfigsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFeatureRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, CreateFeatureRequest> {
    private static final SdkField<String> DEFAULT_VARIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVariation").getter(CreateFeatureRequest.getter(CreateFeatureRequest::defaultVariation)).setter(CreateFeatureRequest.setter(Builder::defaultVariation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariation").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateFeatureRequest.getter(CreateFeatureRequest::description)).setter(CreateFeatureRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> ENTITY_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("entityOverrides").getter(CreateFeatureRequest.getter(CreateFeatureRequest::entityOverrides)).setter(CreateFeatureRequest.setter(Builder::entityOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationStrategy").getter(CreateFeatureRequest.getter(CreateFeatureRequest::evaluationStrategyAsString)).setter(CreateFeatureRequest.setter(Builder::evaluationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationStrategy").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateFeatureRequest.getter(CreateFeatureRequest::name)).setter(CreateFeatureRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(CreateFeatureRequest.getter(CreateFeatureRequest::project)).setter(CreateFeatureRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateFeatureRequest.getter(CreateFeatureRequest::tags)).setter(CreateFeatureRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<VariationConfig>> VARIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variations").getter(CreateFeatureRequest.getter(CreateFeatureRequest::variations)).setter(CreateFeatureRequest.setter(Builder::variations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VARIATION_FIELD, DESCRIPTION_FIELD, ENTITY_OVERRIDES_FIELD, EVALUATION_STRATEGY_FIELD, NAME_FIELD, PROJECT_FIELD, TAGS_FIELD, VARIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFeatureRequest.memberNameToFieldInitializer();
    private final String defaultVariation;
    private final String description;
    private final Map<String, String> entityOverrides;
    private final String evaluationStrategy;
    private final String name;
    private final String project;
    private final Map<String, String> tags;
    private final List<VariationConfig> variations;

    private CreateFeatureRequest(BuilderImpl builder) {
        super(builder);
        this.defaultVariation = builder.defaultVariation;
        this.description = builder.description;
        this.entityOverrides = builder.entityOverrides;
        this.evaluationStrategy = builder.evaluationStrategy;
        this.name = builder.name;
        this.project = builder.project;
        this.tags = builder.tags;
        this.variations = builder.variations;
    }

    public final String defaultVariation() {
        return this.defaultVariation;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEntityOverrides() {
        return this.entityOverrides != null && !(this.entityOverrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> entityOverrides() {
        return this.entityOverrides;
    }

    public final FeatureEvaluationStrategy evaluationStrategy() {
        return FeatureEvaluationStrategy.fromValue(this.evaluationStrategy);
    }

    public final String evaluationStrategyAsString() {
        return this.evaluationStrategy;
    }

    public final String name() {
        return this.name;
    }

    public final String project() {
        return this.project;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasVariations() {
        return this.variations != null && !(this.variations instanceof SdkAutoConstructList);
    }

    public final List<VariationConfig> variations() {
        return this.variations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVariation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityOverrides() ? this.entityOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariations() ? this.variations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFeatureRequest)) {
            return false;
        }
        CreateFeatureRequest other = (CreateFeatureRequest)((Object)obj);
        return Objects.equals(this.defaultVariation(), other.defaultVariation()) && Objects.equals(this.description(), other.description()) && this.hasEntityOverrides() == other.hasEntityOverrides() && Objects.equals(this.entityOverrides(), other.entityOverrides()) && Objects.equals(this.evaluationStrategyAsString(), other.evaluationStrategyAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.project(), other.project()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasVariations() == other.hasVariations() && Objects.equals(this.variations(), other.variations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFeatureRequest").add("DefaultVariation", (Object)this.defaultVariation()).add("Description", (Object)this.description()).add("EntityOverrides", this.hasEntityOverrides() ? this.entityOverrides() : null).add("EvaluationStrategy", (Object)this.evaluationStrategyAsString()).add("Name", (Object)this.name()).add("Project", (Object)this.project()).add("Tags", this.hasTags() ? this.tags() : null).add("Variations", this.hasVariations() ? this.variations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultVariation": {
                return Optional.ofNullable(clazz.cast(this.defaultVariation()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "entityOverrides": {
                return Optional.ofNullable(clazz.cast(this.entityOverrides()));
            }
            case "evaluationStrategy": {
                return Optional.ofNullable(clazz.cast(this.evaluationStrategyAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "variations": {
                return Optional.ofNullable(clazz.cast(this.variations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultVariation", DEFAULT_VARIATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entityOverrides", ENTITY_OVERRIDES_FIELD);
        map.put("evaluationStrategy", EVALUATION_STRATEGY_FIELD);
        map.put("name", NAME_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("variations", VARIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFeatureRequest, T> g) {
        return obj -> g.apply((CreateFeatureRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private String defaultVariation;
        private String description;
        private Map<String, String> entityOverrides = DefaultSdkAutoConstructMap.getInstance();
        private String evaluationStrategy;
        private String name;
        private String project;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<VariationConfig> variations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFeatureRequest model) {
            super(model);
            this.defaultVariation(model.defaultVariation);
            this.description(model.description);
            this.entityOverrides(model.entityOverrides);
            this.evaluationStrategy(model.evaluationStrategy);
            this.name(model.name);
            this.project(model.project);
            this.tags(model.tags);
            this.variations(model.variations);
        }

        public final String getDefaultVariation() {
            return this.defaultVariation;
        }

        public final void setDefaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
        }

        @Override
        public final Builder defaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getEntityOverrides() {
            if (this.entityOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.entityOverrides;
        }

        public final void setEntityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
        }

        @Override
        public final Builder entityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
            return this;
        }

        public final String getEvaluationStrategy() {
            return this.evaluationStrategy;
        }

        public final void setEvaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
        }

        @Override
        public final Builder evaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
            return this;
        }

        @Override
        public final Builder evaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
            this.evaluationStrategy(evaluationStrategy == null ? null : evaluationStrategy.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<VariationConfig.Builder> getVariations() {
            List<VariationConfig.Builder> result = VariationConfigsListCopier.copyToBuilder(this.variations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariations(Collection<VariationConfig.BuilderImpl> variations) {
            this.variations = VariationConfigsListCopier.copyFromBuilder(variations);
        }

        @Override
        public final Builder variations(Collection<VariationConfig> variations) {
            this.variations = VariationConfigsListCopier.copy(variations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variations(VariationConfig ... variations) {
            this.variations(Arrays.asList(variations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variations(Consumer<VariationConfig.Builder> ... variations) {
            this.variations(Stream.of(variations).map(c -> (VariationConfig)((VariationConfig.Builder)VariationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFeatureRequest build() {
            return new CreateFeatureRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFeatureRequest> {
        public Builder defaultVariation(String var1);

        public Builder description(String var1);

        public Builder entityOverrides(Map<String, String> var1);

        public Builder evaluationStrategy(String var1);

        public Builder evaluationStrategy(FeatureEvaluationStrategy var1);

        public Builder name(String var1);

        public Builder project(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder variations(Collection<VariationConfig> var1);

        public Builder variations(VariationConfig ... var1);

        public Builder variations(Consumer<VariationConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

