/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.EntityOverrideMapCopier;
import software.amazon.awssdk.services.evidently.model.EvaluationRule;
import software.amazon.awssdk.services.evidently.model.EvaluationRulesListCopier;
import software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy;
import software.amazon.awssdk.services.evidently.model.FeatureStatus;
import software.amazon.awssdk.services.evidently.model.TagMapCopier;
import software.amazon.awssdk.services.evidently.model.Variation;
import software.amazon.awssdk.services.evidently.model.VariationValueType;
import software.amazon.awssdk.services.evidently.model.VariationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Feature
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Feature> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Feature.getter(Feature::arn)).setter(Feature.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(Feature.getter(Feature::createdTime)).setter(Feature.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> DEFAULT_VARIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVariation").getter(Feature.getter(Feature::defaultVariation)).setter(Feature.setter(Builder::defaultVariation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariation").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Feature.getter(Feature::description)).setter(Feature.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> ENTITY_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("entityOverrides").getter(Feature.getter(Feature::entityOverrides)).setter(Feature.setter(Builder::entityOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<EvaluationRule>> EVALUATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluationRules").getter(Feature.getter(Feature::evaluationRules)).setter(Feature.setter(Builder::evaluationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationStrategy").getter(Feature.getter(Feature::evaluationStrategyAsString)).setter(Feature.setter(Builder::evaluationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationStrategy").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(Feature.getter(Feature::lastUpdatedTime)).setter(Feature.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Feature.getter(Feature::name)).setter(Feature.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(Feature.getter(Feature::project)).setter(Feature.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Feature.getter(Feature::statusAsString)).setter(Feature.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Feature.getter(Feature::tags)).setter(Feature.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("valueType").getter(Feature.getter(Feature::valueTypeAsString)).setter(Feature.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueType").build()}).build();
    private static final SdkField<List<Variation>> VARIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variations").getter(Feature.getter(Feature::variations)).setter(Feature.setter(Builder::variations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Variation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD, DEFAULT_VARIATION_FIELD, DESCRIPTION_FIELD, ENTITY_OVERRIDES_FIELD, EVALUATION_RULES_FIELD, EVALUATION_STRATEGY_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD, PROJECT_FIELD, STATUS_FIELD, TAGS_FIELD, VALUE_TYPE_FIELD, VARIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Feature.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdTime;
    private final String defaultVariation;
    private final String description;
    private final Map<String, String> entityOverrides;
    private final List<EvaluationRule> evaluationRules;
    private final String evaluationStrategy;
    private final Instant lastUpdatedTime;
    private final String name;
    private final String project;
    private final String status;
    private final Map<String, String> tags;
    private final String valueType;
    private final List<Variation> variations;

    private Feature(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.defaultVariation = builder.defaultVariation;
        this.description = builder.description;
        this.entityOverrides = builder.entityOverrides;
        this.evaluationRules = builder.evaluationRules;
        this.evaluationStrategy = builder.evaluationStrategy;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.project = builder.project;
        this.status = builder.status;
        this.tags = builder.tags;
        this.valueType = builder.valueType;
        this.variations = builder.variations;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String defaultVariation() {
        return this.defaultVariation;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEntityOverrides() {
        return this.entityOverrides != null && !(this.entityOverrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> entityOverrides() {
        return this.entityOverrides;
    }

    public final boolean hasEvaluationRules() {
        return this.evaluationRules != null && !(this.evaluationRules instanceof SdkAutoConstructList);
    }

    public final List<EvaluationRule> evaluationRules() {
        return this.evaluationRules;
    }

    public final FeatureEvaluationStrategy evaluationStrategy() {
        return FeatureEvaluationStrategy.fromValue(this.evaluationStrategy);
    }

    public final String evaluationStrategyAsString() {
        return this.evaluationStrategy;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String project() {
        return this.project;
    }

    public final FeatureStatus status() {
        return FeatureStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VariationValueType valueType() {
        return VariationValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public final boolean hasVariations() {
        return this.variations != null && !(this.variations instanceof SdkAutoConstructList);
    }

    public final List<Variation> variations() {
        return this.variations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVariation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityOverrides() ? this.entityOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationRules() ? this.evaluationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariations() ? this.variations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.defaultVariation(), other.defaultVariation()) && Objects.equals(this.description(), other.description()) && this.hasEntityOverrides() == other.hasEntityOverrides() && Objects.equals(this.entityOverrides(), other.entityOverrides()) && this.hasEvaluationRules() == other.hasEvaluationRules() && Objects.equals(this.evaluationRules(), other.evaluationRules()) && Objects.equals(this.evaluationStrategyAsString(), other.evaluationStrategyAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && this.hasVariations() == other.hasVariations() && Objects.equals(this.variations(), other.variations());
    }

    public final String toString() {
        return ToString.builder((String)"Feature").add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("DefaultVariation", (Object)this.defaultVariation()).add("Description", (Object)this.description()).add("EntityOverrides", this.hasEntityOverrides() ? this.entityOverrides() : null).add("EvaluationRules", this.hasEvaluationRules() ? this.evaluationRules() : null).add("EvaluationStrategy", (Object)this.evaluationStrategyAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Name", (Object)this.name()).add("Project", (Object)this.project()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ValueType", (Object)this.valueTypeAsString()).add("Variations", this.hasVariations() ? this.variations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "defaultVariation": {
                return Optional.ofNullable(clazz.cast(this.defaultVariation()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "entityOverrides": {
                return Optional.ofNullable(clazz.cast(this.entityOverrides()));
            }
            case "evaluationRules": {
                return Optional.ofNullable(clazz.cast(this.evaluationRules()));
            }
            case "evaluationStrategy": {
                return Optional.ofNullable(clazz.cast(this.evaluationStrategyAsString()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "valueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "variations": {
                return Optional.ofNullable(clazz.cast(this.variations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("defaultVariation", DEFAULT_VARIATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entityOverrides", ENTITY_OVERRIDES_FIELD);
        map.put("evaluationRules", EVALUATION_RULES_FIELD);
        map.put("evaluationStrategy", EVALUATION_STRATEGY_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("valueType", VALUE_TYPE_FIELD);
        map.put("variations", VARIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Feature, T> g) {
        return obj -> g.apply((Feature)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdTime;
        private String defaultVariation;
        private String description;
        private Map<String, String> entityOverrides = DefaultSdkAutoConstructMap.getInstance();
        private List<EvaluationRule> evaluationRules = DefaultSdkAutoConstructList.getInstance();
        private String evaluationStrategy;
        private Instant lastUpdatedTime;
        private String name;
        private String project;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String valueType;
        private List<Variation> variations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Feature model) {
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.defaultVariation(model.defaultVariation);
            this.description(model.description);
            this.entityOverrides(model.entityOverrides);
            this.evaluationRules(model.evaluationRules);
            this.evaluationStrategy(model.evaluationStrategy);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.name(model.name);
            this.project(model.project);
            this.status(model.status);
            this.tags(model.tags);
            this.valueType(model.valueType);
            this.variations(model.variations);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDefaultVariation() {
            return this.defaultVariation;
        }

        public final void setDefaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
        }

        @Override
        public final Builder defaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getEntityOverrides() {
            if (this.entityOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.entityOverrides;
        }

        public final void setEntityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
        }

        @Override
        public final Builder entityOverrides(Map<String, String> entityOverrides) {
            this.entityOverrides = EntityOverrideMapCopier.copy(entityOverrides);
            return this;
        }

        public final List<EvaluationRule.Builder> getEvaluationRules() {
            List<EvaluationRule.Builder> result = EvaluationRulesListCopier.copyToBuilder(this.evaluationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationRules(Collection<EvaluationRule.BuilderImpl> evaluationRules) {
            this.evaluationRules = EvaluationRulesListCopier.copyFromBuilder(evaluationRules);
        }

        @Override
        public final Builder evaluationRules(Collection<EvaluationRule> evaluationRules) {
            this.evaluationRules = EvaluationRulesListCopier.copy(evaluationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationRules(EvaluationRule ... evaluationRules) {
            this.evaluationRules(Arrays.asList(evaluationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationRules(Consumer<EvaluationRule.Builder> ... evaluationRules) {
            this.evaluationRules(Stream.of(evaluationRules).map(c -> (EvaluationRule)((EvaluationRule.Builder)EvaluationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEvaluationStrategy() {
            return this.evaluationStrategy;
        }

        public final void setEvaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
        }

        @Override
        public final Builder evaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
            return this;
        }

        @Override
        public final Builder evaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
            this.evaluationStrategy(evaluationStrategy == null ? null : evaluationStrategy.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(VariationValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final List<Variation.Builder> getVariations() {
            List<Variation.Builder> result = VariationsListCopier.copyToBuilder(this.variations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariations(Collection<Variation.BuilderImpl> variations) {
            this.variations = VariationsListCopier.copyFromBuilder(variations);
        }

        @Override
        public final Builder variations(Collection<Variation> variations) {
            this.variations = VariationsListCopier.copy(variations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variations(Variation ... variations) {
            this.variations(Arrays.asList(variations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variations(Consumer<Variation.Builder> ... variations) {
            this.variations(Stream.of(variations).map(c -> (Variation)((Variation.Builder)Variation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Feature build() {
            return new Feature(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Feature> {
        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder defaultVariation(String var1);

        public Builder description(String var1);

        public Builder entityOverrides(Map<String, String> var1);

        public Builder evaluationRules(Collection<EvaluationRule> var1);

        public Builder evaluationRules(EvaluationRule ... var1);

        public Builder evaluationRules(Consumer<EvaluationRule.Builder> ... var1);

        public Builder evaluationStrategy(String var1);

        public Builder evaluationStrategy(FeatureEvaluationStrategy var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder name(String var1);

        public Builder project(String var1);

        public Builder status(String var1);

        public Builder status(FeatureStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder valueType(String var1);

        public Builder valueType(VariationValueType var1);

        public Builder variations(Collection<Variation> var1);

        public Builder variations(Variation ... var1);

        public Builder variations(Consumer<Variation.Builder> ... var1);
    }
}

