/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectAppConfigResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectAppConfigResource> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ProjectAppConfigResource.getter(ProjectAppConfigResource::applicationId)).setter(ProjectAppConfigResource.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationProfileId").getter(ProjectAppConfigResource.getter(ProjectAppConfigResource::configurationProfileId)).setter(ProjectAppConfigResource.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationProfileId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(ProjectAppConfigResource.getter(ProjectAppConfigResource::environmentId)).setter(ProjectAppConfigResource.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, ENVIRONMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectAppConfigResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String configurationProfileId;
    private final String environmentId;

    private ProjectAppConfigResource(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.environmentId = builder.environmentId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String configurationProfileId() {
        return this.configurationProfileId;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectAppConfigResource)) {
            return false;
        }
        ProjectAppConfigResource other = (ProjectAppConfigResource)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.environmentId(), other.environmentId());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectAppConfigResource").add("ApplicationId", (Object)this.applicationId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("EnvironmentId", (Object)this.environmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "configurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("configurationProfileId", CONFIGURATION_PROFILE_ID_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectAppConfigResource, T> g) {
        return obj -> g.apply((ProjectAppConfigResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String configurationProfileId;
        private String environmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectAppConfigResource model) {
            this.applicationId(model.applicationId);
            this.configurationProfileId(model.configurationProfileId);
            this.environmentId(model.environmentId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public ProjectAppConfigResource build() {
            return new ProjectAppConfigResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectAppConfigResource> {
        public Builder applicationId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder environmentId(String var1);
    }
}

