/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.EvaluationRule;
import software.amazon.awssdk.services.evidently.model.EvaluationRulesListCopier;
import software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy;
import software.amazon.awssdk.services.evidently.model.FeatureStatus;
import software.amazon.awssdk.services.evidently.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeatureSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeatureSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(FeatureSummary.getter(FeatureSummary::arn)).setter(FeatureSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(FeatureSummary.getter(FeatureSummary::createdTime)).setter(FeatureSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> DEFAULT_VARIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVariation").getter(FeatureSummary.getter(FeatureSummary::defaultVariation)).setter(FeatureSummary.setter(Builder::defaultVariation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariation").build()}).build();
    private static final SdkField<List<EvaluationRule>> EVALUATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluationRules").getter(FeatureSummary.getter(FeatureSummary::evaluationRules)).setter(FeatureSummary.setter(Builder::evaluationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationStrategy").getter(FeatureSummary.getter(FeatureSummary::evaluationStrategyAsString)).setter(FeatureSummary.setter(Builder::evaluationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationStrategy").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(FeatureSummary.getter(FeatureSummary::lastUpdatedTime)).setter(FeatureSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FeatureSummary.getter(FeatureSummary::name)).setter(FeatureSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(FeatureSummary.getter(FeatureSummary::project)).setter(FeatureSummary.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(FeatureSummary.getter(FeatureSummary::statusAsString)).setter(FeatureSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(FeatureSummary.getter(FeatureSummary::tags)).setter(FeatureSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD, DEFAULT_VARIATION_FIELD, EVALUATION_RULES_FIELD, EVALUATION_STRATEGY_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD, PROJECT_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FeatureSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdTime;
    private final String defaultVariation;
    private final List<EvaluationRule> evaluationRules;
    private final String evaluationStrategy;
    private final Instant lastUpdatedTime;
    private final String name;
    private final String project;
    private final String status;
    private final Map<String, String> tags;

    private FeatureSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.defaultVariation = builder.defaultVariation;
        this.evaluationRules = builder.evaluationRules;
        this.evaluationStrategy = builder.evaluationStrategy;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.project = builder.project;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String defaultVariation() {
        return this.defaultVariation;
    }

    public final boolean hasEvaluationRules() {
        return this.evaluationRules != null && !(this.evaluationRules instanceof SdkAutoConstructList);
    }

    public final List<EvaluationRule> evaluationRules() {
        return this.evaluationRules;
    }

    public final FeatureEvaluationStrategy evaluationStrategy() {
        return FeatureEvaluationStrategy.fromValue(this.evaluationStrategy);
    }

    public final String evaluationStrategyAsString() {
        return this.evaluationStrategy;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String project() {
        return this.project;
    }

    public final FeatureStatus status() {
        return FeatureStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVariation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationRules() ? this.evaluationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureSummary)) {
            return false;
        }
        FeatureSummary other = (FeatureSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.defaultVariation(), other.defaultVariation()) && this.hasEvaluationRules() == other.hasEvaluationRules() && Objects.equals(this.evaluationRules(), other.evaluationRules()) && Objects.equals(this.evaluationStrategyAsString(), other.evaluationStrategyAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"FeatureSummary").add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("DefaultVariation", (Object)this.defaultVariation()).add("EvaluationRules", this.hasEvaluationRules() ? this.evaluationRules() : null).add("EvaluationStrategy", (Object)this.evaluationStrategyAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Name", (Object)this.name()).add("Project", (Object)this.project()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "defaultVariation": {
                return Optional.ofNullable(clazz.cast(this.defaultVariation()));
            }
            case "evaluationRules": {
                return Optional.ofNullable(clazz.cast(this.evaluationRules()));
            }
            case "evaluationStrategy": {
                return Optional.ofNullable(clazz.cast(this.evaluationStrategyAsString()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("defaultVariation", DEFAULT_VARIATION_FIELD);
        map.put("evaluationRules", EVALUATION_RULES_FIELD);
        map.put("evaluationStrategy", EVALUATION_STRATEGY_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeatureSummary, T> g) {
        return obj -> g.apply((FeatureSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdTime;
        private String defaultVariation;
        private List<EvaluationRule> evaluationRules = DefaultSdkAutoConstructList.getInstance();
        private String evaluationStrategy;
        private Instant lastUpdatedTime;
        private String name;
        private String project;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureSummary model) {
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.defaultVariation(model.defaultVariation);
            this.evaluationRules(model.evaluationRules);
            this.evaluationStrategy(model.evaluationStrategy);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.name(model.name);
            this.project(model.project);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDefaultVariation() {
            return this.defaultVariation;
        }

        public final void setDefaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
        }

        @Override
        public final Builder defaultVariation(String defaultVariation) {
            this.defaultVariation = defaultVariation;
            return this;
        }

        public final List<EvaluationRule.Builder> getEvaluationRules() {
            List<EvaluationRule.Builder> result = EvaluationRulesListCopier.copyToBuilder(this.evaluationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationRules(Collection<EvaluationRule.BuilderImpl> evaluationRules) {
            this.evaluationRules = EvaluationRulesListCopier.copyFromBuilder(evaluationRules);
        }

        @Override
        public final Builder evaluationRules(Collection<EvaluationRule> evaluationRules) {
            this.evaluationRules = EvaluationRulesListCopier.copy(evaluationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationRules(EvaluationRule ... evaluationRules) {
            this.evaluationRules(Arrays.asList(evaluationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationRules(Consumer<EvaluationRule.Builder> ... evaluationRules) {
            this.evaluationRules(Stream.of(evaluationRules).map(c -> (EvaluationRule)((EvaluationRule.Builder)EvaluationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEvaluationStrategy() {
            return this.evaluationStrategy;
        }

        public final void setEvaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
        }

        @Override
        public final Builder evaluationStrategy(String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
            return this;
        }

        @Override
        public final Builder evaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
            this.evaluationStrategy(evaluationStrategy == null ? null : evaluationStrategy.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public FeatureSummary build() {
            return new FeatureSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeatureSummary> {
        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder defaultVariation(String var1);

        public Builder evaluationRules(Collection<EvaluationRule> var1);

        public Builder evaluationRules(EvaluationRule ... var1);

        public Builder evaluationRules(Consumer<EvaluationRule.Builder> ... var1);

        public Builder evaluationStrategy(String var1);

        public Builder evaluationStrategy(FeatureEvaluationStrategy var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder name(String var1);

        public Builder project(String var1);

        public Builder status(String var1);

        public Builder status(FeatureStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

